/*
 * Decompiled with CFR 0.152.
 */
package de.carne.io;

import de.carne.check.Nullable;
import de.carne.io.LimitOutputStream;
import de.carne.util.PropertiesHelper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class IOHelper {
    private static final int DEFAULT_BUFFER_SIZE = PropertiesHelper.getInt(IOHelper.class, ".bufferSize", 4096);

    private IOHelper() {
    }

    public static byte[] readBytes(InputStream in) throws IOException {
        return IOHelper.readBytes(in, Integer.MAX_VALUE);
    }

    public static byte[] readBytes(InputStream in, int limit) throws IOException {
        byte[] bytes;
        try (LimitOutputStream<ByteArrayOutputStream> out = new LimitOutputStream<ByteArrayOutputStream>(new ByteArrayOutputStream(), limit);){
            IOHelper.copyStream(in, out);
            bytes = out.outputStream().toByteArray();
        }
        return bytes;
    }

    public static long copyStream(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buffer = new byte[DEFAULT_BUFFER_SIZE];
        long copied = 0L;
        while ((read = in.read(buffer)) > 0) {
            out.write(buffer, 0, read);
            copied += (long)read;
        }
        return copied;
    }

    public static List<Path> collectDirectoryFiles(Path start, FileVisitOption ... options) throws IOException {
        return IOHelper.collectDirectoryFiles(start, (Path p) -> Files.isRegularFile(p, new LinkOption[0]), options);
    }

    public static List<Path> collectDirectoryFiles(Path start, Predicate<Path> filter, FileVisitOption ... options) throws IOException {
        List<Path> collection;
        try (Stream<Path> stream = Files.walk(start, options);){
            collection = stream.filter(filter).collect(Collectors.toList());
        }
        return collection;
    }

    public static void deleteDirectoryTree(String directory) throws IOException {
        IOHelper.deleteDirectoryTree(Paths.get(directory, new String[0]));
    }

    public static void deleteDirectoryTree(File directory) throws IOException {
        IOHelper.deleteDirectoryTree(directory.toPath());
    }

    public static void deleteDirectoryTree(Path directory) throws IOException {
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(@Nullable Path file, @Nullable BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return super.visitFile(file, attrs);
            }

            @Override
            public FileVisitResult postVisitDirectory(@Nullable Path dir, @Nullable IOException exc) throws IOException {
                if (exc == null) {
                    Files.delete(dir);
                }
                return super.postVisitDirectory(dir, exc);
            }
        });
    }

    public static Path createTempFileFromResource(URL resource, @Nullable String prefix, @Nullable String suffix, FileAttribute<?> ... attrs) throws IOException {
        return IOHelper.copyResourceToFile(resource, Files.createTempFile(prefix, suffix, attrs));
    }

    public static Path createTempFileFromResource(URL resource, Path dir, String prefix, String suffix, FileAttribute<?> ... attrs) throws IOException {
        return IOHelper.copyResourceToFile(resource, Files.createTempFile(dir, prefix, suffix, attrs));
    }

    private static Path copyResourceToFile(URL resource, Path file) throws IOException {
        try (InputStream in = resource.openStream();
             OutputStream out = Files.newOutputStream(file, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            IOHelper.copyStream(in, out);
        }
        return file;
    }

    public static Path createTempDirFromZIPResource(URL resource, @Nullable String prefix, FileAttribute<?> ... attrs) throws IOException {
        return IOHelper.exportZIPResourceToDirectory(resource, Files.createTempDirectory(prefix, attrs), new FileAttribute[0]);
    }

    public static Path createTempDirFromZIPResource(URL resource, Path dir, @Nullable String prefix, FileAttribute<?> ... attrs) throws IOException {
        return IOHelper.exportZIPResourceToDirectory(resource, Files.createTempDirectory(dir, prefix, attrs), attrs);
    }

    private static Path exportZIPResourceToDirectory(URL resource, Path dir, FileAttribute<?> ... attrs) throws IOException {
        try (ZipInputStream in = new ZipInputStream(resource.openStream());){
            ZipEntry entry;
            while ((entry = in.getNextEntry()) != null) {
                Path entryPath = dir.resolve(entry.getName());
                if (entry.isDirectory()) {
                    Files.createDirectories(entryPath, attrs);
                } else {
                    Files.createDirectories(entryPath.getParent(), attrs);
                    try (OutputStream out = Files.newOutputStream(entryPath, StandardOpenOption.CREATE_NEW);){
                        IOHelper.copyStream(in, out);
                    }
                }
                in.closeEntry();
            }
        }
        return dir;
    }
}

