/*
 * Decompiled with CFR 0.152.
 */
package de.carne;

import de.carne.util.logging.Log;
import java.util.ArrayList;
import java.util.List;

public final class ApplicationShutdownTask {
    private static final Log LOG = new Log();
    private static final List<ApplicationShutdownTask> APPLICATION_CLEANUP_TASKS = new ArrayList<ApplicationShutdownTask>();
    private final String name;
    private final Runnable runnable;
    private boolean triggered = false;

    public static synchronized void register(String name, Runnable runnable) {
        APPLICATION_CLEANUP_TASKS.add(new ApplicationShutdownTask(name, runnable));
    }

    public static synchronized void trigger() {
        LOG.info("Triggering shutdown tasks...", new Object[0]);
        for (ApplicationShutdownTask task : APPLICATION_CLEANUP_TASKS) {
            task.run();
        }
    }

    private ApplicationShutdownTask(String name, Runnable runnable) {
        this.name = name;
        this.runnable = runnable;
    }

    private void run() {
        if (!this.triggered) {
            LOG.info(" {0}...", this.name);
            try {
                this.triggered = true;
                this.runnable.run();
            }
            catch (Exception e) {
                LOG.warning(e, "An exception occurred while running shutdown task {0}", this.name);
            }
        }
    }

    static {
        LOG.info("Registering shutdown hook...", new Object[0]);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ApplicationShutdownTask.trigger(), ApplicationShutdownTask.class.getSimpleName()));
    }
}

