/*
 * Decompiled with CFR 0.152.
 */
package de.carne.nio.compression.deflate;

final class DeflateLevels {
    public byte[] levels = new byte[320];
    public final byte[] litLenLevels = new byte[288];
    public final byte[] distLevels = new byte[32];

    DeflateLevels() {
    }

    public void subClear() {
        int levelIndex;
        for (levelIndex = 257; levelIndex < this.litLenLevels.length; ++levelIndex) {
            this.litLenLevels[levelIndex] = 0;
        }
        for (levelIndex = 0; levelIndex < this.distLevels.length; ++levelIndex) {
            this.distLevels[levelIndex] = 0;
        }
    }

    public void setFixedLevels() {
        int levelIndex;
        for (levelIndex = 0; levelIndex < 144; ++levelIndex) {
            this.litLenLevels[levelIndex] = 8;
        }
        while (levelIndex < 256) {
            this.litLenLevels[levelIndex] = 9;
            ++levelIndex;
        }
        while (levelIndex < 280) {
            this.litLenLevels[levelIndex] = 7;
            ++levelIndex;
        }
        while (levelIndex < 288) {
            this.litLenLevels[levelIndex] = 8;
            ++levelIndex;
        }
        for (levelIndex = 0; levelIndex < this.distLevels.length; ++levelIndex) {
            this.distLevels[levelIndex] = 5;
        }
    }

    public void setLevels(int numLitLenLevels, int numDistLevels) {
        System.arraycopy(this.levels, 0, this.litLenLevels, 0, numLitLenLevels);
        System.arraycopy(this.levels, numLitLenLevels, this.distLevels, 0, numDistLevels);
    }
}

