/*
 * Decompiled with CFR 0.152.
 */
package de.carne.nio.compression.deflate;

import de.carne.nio.compression.InvalidDataException;
import de.carne.nio.compression.common.BitDecoder;
import de.carne.nio.compression.common.BitRegister;
import de.carne.nio.compression.common.HistoryBuffer;
import de.carne.nio.compression.common.HuffmanDecoder;
import de.carne.nio.compression.common.LSBBitstreamBitRegister;
import de.carne.nio.compression.common.LSBBytesBitRegister;
import de.carne.nio.compression.deflate.Deflate;
import de.carne.nio.compression.deflate.DeflateLevels;
import de.carne.nio.compression.deflate.DeflateMode;
import de.carne.nio.compression.deflate.DeflateName;
import de.carne.nio.compression.spi.Decoder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class DeflateDecoder
extends Decoder
implements DeflateName {
    private final HashSet<DeflateMode> modes;
    private final BitDecoder bitDecoder = new BitDecoder(new BitRegister[]{new LSBBitstreamBitRegister(), new LSBBytesBitRegister()}, -1, -1, -1, -1);
    private final HuffmanDecoder mainDecoder = new HuffmanDecoder(15, 288);
    private final HuffmanDecoder distDecoder = new HuffmanDecoder(15, 32);
    private final HuffmanDecoder levelDecoder = new HuffmanDecoder(15, 19);
    private final HistoryBuffer historyBuffer;
    private int blockRemaining;
    private boolean readTables;
    private boolean finalBlock;
    private int rep0Dist;
    private boolean storedMode;
    private int storedBlockSize;
    private int numDistLevels;

    public DeflateDecoder() {
        this(Collections.EMPTY_SET);
    }

    public DeflateDecoder(Set<DeflateMode> modes) {
        assert (modes != null);
        this.modes = new HashSet<DeflateMode>(modes);
        this.historyBuffer = new HistoryBuffer(this.modes.contains((Object)DeflateMode.OPTION_HISTORY64K) ? 65536 : 32768);
        this.init();
    }

    private void init() {
        this.bitDecoder.reset();
        this.historyBuffer.clear();
        this.blockRemaining = -2;
        this.readTables = true;
        this.finalBlock = false;
        this.blockRemaining = -2;
        this.rep0Dist = -1;
        this.storedMode = false;
        this.storedBlockSize = 0;
        this.numDistLevels = 0;
    }

    @Override
    public synchronized void reset() {
        super.reset();
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int decode(ByteBuffer dst, ReadableByteChannel src) throws IOException {
        long beginTime = this.beginProcessing();
        int decoded = -1;
        int emitted = 0;
        try {
            if (this.blockRemaining != -1) {
                long decodeStart = this.bitDecoder.totalIn();
                if (decodeStart == 0L && this.modes.contains((Object)DeflateMode.FORMAT_ZLIB)) {
                    this.processZLibHeader(src);
                }
                emitted += this.historyBuffer.flush(dst);
                int decodeRemaining = dst.remaining();
                while (decodeRemaining > 0 && this.blockRemaining != -1) {
                    this.decodeBlock(src, Math.min(decodeRemaining, this.historyBuffer.getSize() >>> 1));
                    emitted += this.historyBuffer.flush(dst);
                    decodeRemaining = dst.remaining();
                }
                emitted += this.historyBuffer.flush(dst);
                if (this.blockRemaining == -1 && this.modes.contains((Object)DeflateMode.FORMAT_ZLIB)) {
                    this.processZLibTrailer(src);
                }
                decoded = (int)(this.bitDecoder.totalIn() - decodeStart);
            } else if (this.modes.contains((Object)DeflateMode.OPTION_RESTART_AFTER_EOS)) {
                this.blockRemaining = -2;
                this.bitDecoder.clear();
            }
        }
        finally {
            this.endProcessing(beginTime, Math.max(decoded, 0), emitted);
        }
        return decoded;
    }

    private void processZLibHeader(ReadableByteChannel src) throws IOException {
        this.bitDecoder.decodeBits(src, 8, 1);
        this.bitDecoder.decodeBits(src, 4, 1);
        this.bitDecoder.decodeBits(src, 4, 1);
    }

    private void processZLibTrailer(ReadableByteChannel src) throws IOException {
        this.bitDecoder.alignToByte();
        this.bitDecoder.decodeBits(src, 8, 1);
        this.bitDecoder.decodeBits(src, 8, 1);
        this.bitDecoder.decodeBits(src, 8, 1);
        this.bitDecoder.decodeBits(src, 8, 1);
    }

    private void decodeBlock(ReadableByteChannel src, int len) throws IOException {
        boolean done1;
        int decodeRemaining = len;
        if (this.blockRemaining == -2) {
            if (!this.modes.contains((Object)DeflateMode.OPTION_KEEP_HISTORY)) {
                this.historyBuffer.clear();
            }
            this.readTables = true;
            this.finalBlock = false;
            this.blockRemaining = 0;
        } else if (this.blockRemaining > 0) {
            int decodeLen = Math.min(this.blockRemaining, decodeRemaining);
            this.historyBuffer.copyBlock(this.rep0Dist, decodeLen);
            this.blockRemaining -= decodeLen;
            decodeRemaining -= decodeLen;
        }
        boolean bl = done1 = decodeRemaining <= 0;
        while (!done1) {
            boolean done2;
            if (this.readTables) {
                if (!this.finalBlock) {
                    this.readTables(src);
                    this.readTables = false;
                } else {
                    this.blockRemaining = -1;
                    done1 = true;
                }
            }
            if (done1) continue;
            if (this.storedMode) {
                int writeBufferLen = Math.min(decodeRemaining, this.storedBlockSize);
                this.historyBuffer.putBytes(this.bitDecoder, src, writeBufferLen);
                this.storedBlockSize -= writeBufferLen;
                this.readTables = this.storedBlockSize == 0;
                done1 = (decodeRemaining -= writeBufferLen) <= 0;
                continue;
            }
            boolean bl2 = done2 = decodeRemaining <= 0;
            while (!done2) {
                int symbol = this.mainDecoder.decodeSymbol(src, this.bitDecoder, 0);
                if (symbol < 0) {
                    throw new InvalidDataException(symbol);
                }
                if (symbol < 256) {
                    this.historyBuffer.putByte((byte)symbol);
                    done2 = --decodeRemaining <= 0;
                    continue;
                }
                if (symbol == 256) {
                    this.readTables = true;
                    done2 = true;
                    continue;
                }
                if (symbol < 286) {
                    int decodeLen1 = this.modes.contains((Object)DeflateMode.OPTION_HISTORY64K) ? (Deflate.LEN_START_64[symbol] & 0xFF) + 3 + this.bitDecoder.decodeBits(src, Deflate.LEN_DIRECT_BITS_64[symbol] & 0xFF, 1) : (Deflate.LEN_START_32[symbol -= 257] & 0xFF) + 3 + this.bitDecoder.decodeBits(src, Deflate.LEN_DIRECT_BITS_32[symbol] & 0xFF, 1);
                    int decodeLen2 = Math.min(decodeLen1, decodeRemaining);
                    symbol = this.distDecoder.decodeSymbol(src, this.bitDecoder, 0);
                    if (symbol >= this.numDistLevels) {
                        throw new InvalidDataException(symbol);
                    }
                    int dist = Deflate.DIST_START[symbol] + this.bitDecoder.decodeBits(src, Deflate.DIST_DIRECT_BITS[symbol], 1);
                    this.historyBuffer.copyBlock(dist, decodeLen2);
                    decodeRemaining -= decodeLen2;
                    if ((decodeLen1 -= decodeLen2) == 0) {
                        done2 = decodeRemaining <= 0;
                        continue;
                    }
                    this.blockRemaining = decodeLen1;
                    this.rep0Dist = dist;
                    done2 = true;
                    continue;
                }
                throw new InvalidDataException(symbol);
            }
            done1 = decodeRemaining <= 0;
        }
    }

    private void readTables(ReadableByteChannel src) throws IOException {
        this.finalBlock = this.bitDecoder.decodeBits(src, 1, 1) != 0;
        int blockType = this.bitDecoder.decodeBits(src, 2, 1);
        switch (blockType) {
            case 0: {
                int storedBlockSizeCheck;
                this.storedMode = true;
                this.bitDecoder.alignToByte();
                this.storedBlockSize = this.bitDecoder.decodeBits(src, 16, 1);
                if (this.modes.contains((Object)DeflateMode.FORMAT_NSIS) || ((this.storedBlockSize ^ (storedBlockSizeCheck = this.bitDecoder.decodeBits(src, 16, 1))) & 0xFFFF) == 65535) break;
                throw new InvalidDataException(this.storedBlockSize, storedBlockSizeCheck);
            }
            case 1: {
                this.storedMode = false;
                DeflateLevels levels = new DeflateLevels();
                levels.setFixedLevels();
                this.numDistLevels = this.modes.contains((Object)DeflateMode.OPTION_HISTORY64K) ? 32 : 30;
                this.mainDecoder.setCodeLengths(levels.litLenLevels);
                this.distDecoder.setCodeLengths(levels.distLevels);
                break;
            }
            case 2: {
                this.storedMode = false;
                int numLitLenLevels = this.bitDecoder.decodeBits(src, 5, 1) + 257;
                this.numDistLevels = this.bitDecoder.decodeBits(src, 5, 1) + 1;
                if (!this.modes.contains((Object)DeflateMode.OPTION_HISTORY64K) && this.numDistLevels > 30) {
                    throw new InvalidDataException(this.numDistLevels);
                }
                int numLevelCodes = this.bitDecoder.decodeBits(src, 4, 1) + 4;
                byte[] levelLevels = new byte[19];
                for (int levelIndex = 0; levelIndex < levelLevels.length; ++levelIndex) {
                    int position = Deflate.CODE_LENGTH_ALPHABET_ORDER[levelIndex] & 0xFF;
                    levelLevels[position] = levelIndex < numLevelCodes ? (byte)this.bitDecoder.decodeBits(src, 3, 1) : (byte)0;
                }
                this.levelDecoder.setCodeLengths(levelLevels);
                DeflateLevels levels = new DeflateLevels();
                this.decodeLevels(src, levels, numLitLenLevels + this.numDistLevels);
                levels.subClear();
                levels.setLevels(numLitLenLevels, this.numDistLevels);
                this.mainDecoder.setCodeLengths(levels.litLenLevels);
                this.distDecoder.setCodeLengths(levels.distLevels);
                break;
            }
            default: {
                throw new InvalidDataException(blockType);
            }
        }
    }

    private void decodeLevels(ReadableByteChannel src, DeflateLevels levels, int numSymbols) throws IOException {
        int levelIndex = 0;
        while (levelIndex < numSymbols) {
            int repNum;
            int symbol = this.levelDecoder.decodeSymbol(src, this.bitDecoder, 0);
            if (symbol < 0 || 19 <= symbol) {
                throw new InvalidDataException(symbol);
            }
            if (symbol < 16) {
                levels.levels[levelIndex] = (byte)symbol;
                ++levelIndex;
                continue;
            }
            if (symbol == 16) {
                if (levelIndex == 0) {
                    throw new InvalidDataException(new Number[0]);
                }
                for (repNum = this.bitDecoder.decodeBits(src, 2, 1) + 3; repNum > 0 && levelIndex < numSymbols; ++levelIndex, --repNum) {
                    levels.levels[levelIndex] = levels.levels[levelIndex - 1];
                }
                continue;
            }
            int n = repNum = symbol == 17 ? this.bitDecoder.decodeBits(src, 3, 1) + 3 : this.bitDecoder.decodeBits(src, 7, 1) + 11;
            while (repNum > 0 && levelIndex < numSymbols) {
                levels.levels[levelIndex] = 0;
                ++levelIndex;
                --repNum;
            }
        }
    }

    @Override
    public String name() {
        return "Deflate compression";
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.name()).append(' ').append(this.modes);
        return buffer.toString();
    }
}

