/*
 * Decompiled with CFR 0.152.
 */
package de.carne.nio.compression.common;

import de.carne.nio.compression.common.BitRegister;
import de.carne.nio.compression.util.Assert;

public final class LSBBytesBitRegister
extends BitRegister {
    @Override
    public int feedBits(byte b) {
        Assert.inState(this.bitCount < 32, "bitCount", this.bitCount);
        this.register |= (long)((b & 0xFF) << this.bitCount);
        this.bitCount += 8;
        return this.bitCount;
    }

    @Override
    public int peekBits(int count) {
        int bits;
        Assert.isValid(count >= 0, "count", count);
        Assert.inState(this.bitCount + count < 40, "bitCount", this.bitCount, "count", count);
        switch (count) {
            case 0: {
                bits = 0;
                break;
            }
            case 32: {
                bits = (int)this.register;
                break;
            }
            default: {
                bits = (int)(this.register & (long)(~(-1 << count)));
            }
        }
        return bits;
    }

    @Override
    public int discardBits(int count) {
        Assert.isValid(count >= 0, "count", count);
        Assert.inState(this.bitCount + count < 40, "bitCount", this.bitCount, "count", count);
        this.register >>>= count;
        this.bitCount -= count;
        return this.bitCount;
    }
}

