/*
 * Decompiled with CFR 0.152.
 */
package de.carne.nio.compression.common;

import de.carne.nio.compression.InvalidDataException;
import de.carne.nio.compression.common.BitDecoder;
import de.carne.nio.compression.util.Assert;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;

public final class HuffmanDecoder {
    private static final int LENGTHS_TABLE_BITS = 9;
    private final int[] limits;
    private final int[] positions;
    private final int[] symbols;
    byte[] lengths;

    public HuffmanDecoder(int maxBits, int maxSymbols) {
        Assert.isValid(maxBits > 0, "maxBits", maxBits);
        Assert.isValid(maxSymbols > 0, "maxSymbols", maxSymbols);
        this.limits = new int[maxBits + 1];
        this.positions = new int[maxBits + 1];
        this.symbols = new int[maxSymbols];
        this.lengths = new byte[512];
    }

    public void setCodeLengths(byte[] codeLengths) throws IOException {
        int maxBits = this.limits.length - 1;
        int maxSymbols = this.symbols.length;
        int[] lengthCounts = new int[maxBits + 1];
        int[] positions2 = new int[maxBits + 1];
        for (int symbol = 0; symbol < maxSymbols; ++symbol) {
            int length = codeLengths[symbol] & 0xFF;
            if (length > maxBits) {
                throw new InvalidDataException(length);
            }
            int n = length;
            lengthCounts[n] = lengthCounts[n] + 1;
            this.symbols[symbol] = -1;
        }
        this.limits[0] = 0;
        this.positions[0] = 0;
        lengthCounts[0] = 0;
        int startPosition = 0;
        int index = 0;
        int maxValue = 1 << maxBits;
        for (int value = 1; value <= maxBits; ++value) {
            if ((startPosition += lengthCounts[value] << maxBits - value) > maxValue) {
                throw new InvalidDataException(new Number[0]);
            }
            this.limits[value] = value == maxBits ? maxValue : startPosition;
            this.positions[value] = this.positions[value - 1] + lengthCounts[value - 1];
            positions2[value] = this.positions[value];
            if (value > 9) continue;
            int limit = this.limits[value] >> maxBits - 9;
            while (index < limit) {
                this.lengths[index] = (byte)value;
                ++index;
            }
        }
        for (int symbol = 0; symbol < maxSymbols; ++symbol) {
            int length = codeLengths[symbol] & 0xFF;
            if (length == 0) continue;
            int n = length;
            int n2 = positions2[n];
            positions2[n] = n2 + 1;
            this.symbols[n2] = symbol;
        }
    }

    public int decodeSymbol(ReadableByteChannel src, BitDecoder bitDecoder, int bufferIndex) throws IOException {
        int symbolLength;
        int maxBits = this.positions.length - 1;
        int value = bitDecoder.peekBits(src, maxBits, bufferIndex);
        if (value < this.limits[9]) {
            symbolLength = this.lengths[value >> maxBits - 9] & 0xFF;
        } else {
            symbolLength = 10;
            while (value >= this.limits[symbolLength]) {
                ++symbolLength;
            }
        }
        bitDecoder.decodeBits(src, symbolLength, bufferIndex);
        int index = this.positions[symbolLength] + (value - this.limits[symbolLength - 1] >> maxBits - symbolLength);
        return index < this.symbols.length ? this.symbols[index] : -1;
    }
}

