/*
 * Decompiled with CFR 0.152.
 */
package de.carne.nio.compression.common;

import de.carne.nio.compression.IncompleteReadException;
import de.carne.nio.compression.InvalidDataException;
import de.carne.nio.compression.common.BitDecoder;
import de.carne.nio.compression.util.Assert;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public final class HistoryBuffer {
    private final byte[] buffer;
    private int bufferBeginPos;
    private int bufferEndPos;
    private int bufferCopyLimit;

    public HistoryBuffer(int size) {
        Assert.isValid(size > 0, "size", size);
        this.buffer = new byte[size];
        this.clear();
    }

    public int getSize() {
        return this.buffer.length;
    }

    public void clear() {
        this.bufferBeginPos = 0;
        this.bufferEndPos = 0;
        this.bufferCopyLimit = 0;
    }

    public void putByte(byte b) {
        this.buffer[this.bufferBeginPos] = b;
        this.bufferBeginPos = (this.bufferBeginPos + 1) % this.buffer.length;
        this.bufferCopyLimit = Math.min(this.bufferCopyLimit + 1, this.buffer.length);
    }

    public void putBytes(BitDecoder bitDecoder, ReadableByteChannel src, int length) throws IOException {
        int readLength;
        for (int remaining = length; remaining > 0; remaining -= readLength) {
            readLength = Math.min(length, this.buffer.length - this.bufferBeginPos);
            ByteBuffer readBuffer = ByteBuffer.wrap(this.buffer, this.bufferBeginPos, readLength);
            int read = bitDecoder.readBytes(src, readBuffer);
            if (read < readLength) {
                throw new IncompleteReadException(readLength, read);
            }
            this.bufferBeginPos = (this.bufferBeginPos + readLength) % this.buffer.length;
            this.bufferCopyLimit = Math.min(this.bufferCopyLimit + readLength, this.buffer.length);
        }
    }

    public void copyBlock(int dist, int len) throws IOException {
        int copyLen;
        if (dist >= this.bufferCopyLimit) {
            throw new InvalidDataException(this.bufferCopyLimit, dist, len);
        }
        int copyPos = this.bufferBeginPos - dist - 1;
        if (copyPos < 0) {
            copyPos += this.buffer.length;
        }
        for (int remaining = len; remaining > 0; remaining -= copyLen) {
            copyLen = Math.min(this.buffer.length - Math.max(this.bufferBeginPos, copyPos), remaining);
            for (int copyIndex = 0; copyIndex < copyLen; ++copyIndex) {
                this.buffer[this.bufferBeginPos + copyIndex] = this.buffer[copyPos + copyIndex];
            }
            this.bufferBeginPos = (this.bufferBeginPos + copyLen) % this.buffer.length;
            copyPos = (copyPos + copyLen) % this.buffer.length;
        }
        this.bufferCopyLimit = Math.min(this.bufferCopyLimit + len, this.buffer.length);
    }

    public int flush(ByteBuffer dst) {
        int len = 0;
        if (this.bufferEndPos != this.bufferBeginPos) {
            if (this.bufferEndPos > this.bufferBeginPos) {
                len = Math.min(this.buffer.length - this.bufferEndPos, dst.remaining());
                dst.put(this.buffer, this.bufferEndPos, len);
                this.bufferEndPos = (this.bufferEndPos + len) % this.buffer.length;
            }
            if (this.bufferEndPos < this.bufferBeginPos) {
                len = Math.min(this.bufferBeginPos - this.bufferEndPos, dst.remaining());
                dst.put(this.buffer, this.bufferEndPos, len);
                this.bufferEndPos = (this.bufferEndPos + len) % this.buffer.length;
            }
        }
        return len;
    }
}

