/*
 * Decompiled with CFR 0.152.
 */
package de.carne.nio.compression.common;

import de.carne.nio.compression.common.BitRegister;
import de.carne.nio.compression.util.Assert;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public final class BitDecoder {
    private final BitRegister[] registers;
    private final byte[] trailingBytes;
    private int trailingBytesIndex;
    private long totalInBits;

    public BitDecoder(BitRegister[] registers) {
        this(registers, null);
    }

    public BitDecoder(BitRegister[] registers, byte ... trailingBytes) {
        Assert.notNull(registers, "registers");
        Assert.notEmpty(registers.length, "registers");
        this.registers = new BitRegister[registers.length];
        System.arraycopy(registers, 0, this.registers, 0, registers.length);
        if (trailingBytes != null) {
            this.trailingBytes = new byte[trailingBytes.length];
            System.arraycopy(trailingBytes, 0, this.trailingBytes, 0, trailingBytes.length);
        } else {
            this.trailingBytes = new byte[0];
        }
        this.init();
    }

    private void init() {
        this.trailingBytesIndex = 0;
        this.totalInBits = 0L;
    }

    public void reset() {
        this.clear();
        this.init();
    }

    public void clear() {
        this.totalInBits += (long)this.registers[0].bitCount();
        for (BitRegister register : this.registers) {
            register.clear();
        }
    }

    public long totalIn() {
        return this.totalInBits + 7L >>> 3;
    }

    public int peekBits(ReadableByteChannel src, int count) throws IOException {
        return this.peekBits(src, count, 0);
    }

    public int peekBits(ReadableByteChannel src, int count, int registerIndex) throws IOException {
        Assert.notNull(src, "src");
        Assert.isValid(count >= 0, "count", count);
        Assert.isValid(0 <= registerIndex && registerIndex < this.registers.length, "registerIndex", registerIndex);
        this.feedBytes(src, count);
        return this.registers[registerIndex].peekBits(count);
    }

    public int decodeBits(ReadableByteChannel src, int count) throws IOException {
        return this.decodeBits(src, count, 0);
    }

    public int decodeBits(ReadableByteChannel src, int count, int registerIndex) throws IOException {
        Assert.notNull(src, "src");
        Assert.isValid(count >= 0, "count", count);
        Assert.isValid(0 <= registerIndex && registerIndex < this.registers.length, "registerIndex", registerIndex);
        int bits = this.peekBits(src, count, registerIndex);
        this.totalInBits += (long)count;
        for (BitRegister register : this.registers) {
            register.discardBits(count);
        }
        return bits;
    }

    public void alignToByte() {
        int discardCount = this.registers[0].bitCount() % 8;
        if (discardCount != 0) {
            this.totalInBits += (long)discardCount;
            for (BitRegister register : this.registers) {
                register.discardBits(discardCount);
            }
        }
    }

    public int readBytes(ReadableByteChannel src, ByteBuffer dst) throws IOException {
        int directRead;
        Assert.notNull(src, "src");
        Assert.notNull(dst, "dst");
        this.alignToByte();
        BitRegister register0 = this.registers[0];
        int read = 0;
        while (register0.bitCount() > 0 && dst.hasRemaining()) {
            dst.put((byte)register0.peekBits(8));
            for (BitRegister register : this.registers) {
                register.discardBits(8);
            }
            ++read;
        }
        int n = directRead = dst.hasRemaining() ? src.read(dst) : 0;
        if (directRead >= 0) {
            this.totalInBits += (long)((read += directRead) * 8);
        } else if (read > 0) {
            this.totalInBits += (long)(read * 8);
        } else {
            read = -1;
        }
        return read;
    }

    public int readByte(ReadableByteChannel src) throws IOException {
        int read;
        Assert.notNull(src, "src");
        this.alignToByte();
        BitRegister register0 = this.registers[0];
        if (register0.bitCount() > 0) {
            read = register0.peekBits(8) & 0xFF;
            this.totalInBits += 8L;
            for (BitRegister register : this.registers) {
                register.discardBits(8);
            }
        } else {
            ByteBuffer readBuffer = ByteBuffer.allocate(1);
            read = src.read(readBuffer);
            readBuffer.flip();
            if (read == 1) {
                read = readBuffer.get() & 0xFF;
                this.totalInBits += 8L;
            }
        }
        return read;
    }

    private void feedBytes(ReadableByteChannel src, int count) throws IOException {
        int currentBitcount = this.registers[0].bitCount();
        if (count > currentBitcount) {
            int feedBytesRemainingCount = (count - currentBitcount + 7) / 8;
            if (this.trailingBytesIndex == 0) {
                ByteBuffer readBuffer = ByteBuffer.allocate(feedBytesRemainingCount);
                src.read(readBuffer);
                readBuffer.flip();
                while (readBuffer.hasRemaining()) {
                    byte b = readBuffer.get();
                    BitRegister[] bitRegisterArray = this.registers;
                    int n = bitRegisterArray.length;
                    for (int i = 0; i < n; ++i) {
                        BitRegister register = bitRegisterArray[i];
                        register.feedBits(b);
                    }
                    --feedBytesRemainingCount;
                }
            }
            while (feedBytesRemainingCount > 0) {
                if (this.trailingBytesIndex >= this.trailingBytes.length) {
                    throw new EOFException("Unable to read remaining bytes: " + feedBytesRemainingCount);
                }
                byte b = this.trailingBytes[this.trailingBytesIndex];
                for (BitRegister register : this.registers) {
                    register.feedBits(b);
                }
                ++this.trailingBytesIndex;
                --feedBytesRemainingCount;
            }
        }
    }
}

