/*
 * Decompiled with CFR 0.152.
 */
package de.carne.nio.compression;

import de.carne.nio.compression.util.Assert;

public abstract class Compression {
    private long processingNanos = 0L;
    private long totalIn = 0L;
    private long totalOut = 0L;

    public abstract String name();

    public synchronized void reset() {
        this.processingNanos = 0L;
        this.totalIn = 0L;
        this.totalOut = 0L;
    }

    public final synchronized long processingTime() {
        return this.processingNanos / 1000000L;
    }

    public final synchronized long totalIn() {
        return this.totalIn;
    }

    public final synchronized long rateIn() {
        return this.processingNanos >= 1000000L ? this.totalIn * 1000L / (this.processingNanos / 1000000L) : 0L;
    }

    public final synchronized long totalOut() {
        return this.totalOut;
    }

    public final synchronized long rateOut() {
        return this.processingNanos >= 1000000L ? this.totalOut * 1000L / (this.processingNanos / 1000000L) : 0L;
    }

    protected final synchronized long beginProcessing() {
        return System.nanoTime();
    }

    protected final synchronized void endProcessing(long beginTime, long in, long out) {
        long currentNanos = System.nanoTime();
        Assert.isValid(in >= 0L, "in", in);
        Assert.isValid(out >= 0L, "out", out);
        this.processingNanos += currentNanos - beginTime;
        this.totalIn += in;
        this.totalOut += out;
    }
}

