/*
 * Decompiled with CFR 0.152.
 */
package de.carne.swt.browseradapter.platform;

import de.carne.util.Exceptions;
import de.carne.util.Lazy;
import org.eclipse.swt.SWT;

public abstract class PlatformHelper {
    private static final Lazy<PlatformHelper> INSTANCE_HOLDER = new Lazy(PlatformHelper::getInstance);

    private static PlatformHelper getInstance() {
        PlatformHelper instance;
        try {
            String platform = SWT.getPlatform();
            String platformName = PlatformHelper.class.getPackage().getName() + "." + platform + "." + platform.substring(0, 1).toUpperCase() + platform.substring(1) + PlatformHelper.class.getSimpleName();
            instance = Class.forName(platformName).asSubclass(PlatformHelper.class).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw Exceptions.toRuntime((Throwable)e);
        }
        return instance;
    }

    protected PlatformHelper() {
    }

    public static boolean isWebKitAvailable() {
        return ((PlatformHelper)INSTANCE_HOLDER.get()).internalIsWebKitAvailable();
    }

    protected boolean internalIsWebKitAvailable() {
        return true;
    }

    public static boolean isChromiumAvailable() {
        return ((PlatformHelper)INSTANCE_HOLDER.get()).internalIsChromiumAvailable();
    }

    protected boolean internalIsChromiumAvailable() {
        boolean isAvailable = false;
        try {
            Class.forName("org.eclipse.swt.browser.ChromiumImpl");
            isAvailable = true;
        }
        catch (Exception e) {
            Exceptions.ignore((Throwable)e);
        }
        return isAvailable;
    }
}

