/*
 * Decompiled with CFR 0.152.
 */
package de.carne.swt.browseradapter;

import de.carne.swt.browseradapter.BrowserInstance;
import de.carne.swt.browseradapter.spi.BrowserAdapterProvider;
import java.util.Arrays;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import org.eclipse.swt.widgets.Composite;

public abstract class BrowserAdapter
implements BrowserInstance,
Supplier<Composite> {
    private final BrowserAdapterProvider provider;

    protected BrowserAdapter(BrowserAdapterProvider provider) {
        this.provider = provider;
    }

    public static Iterable<BrowserAdapterProvider> providers() {
        return ServiceLoader.load(BrowserAdapterProvider.class);
    }

    public static BrowserAdapter getInstance(Composite parent, int style, String ... providerNames) {
        BrowserAdapterProvider matchingProvider = null;
        int matchingProviderNameIndex = providerNames.length;
        Iterator<BrowserAdapterProvider> providers = BrowserAdapter.providers().iterator();
        block0: while (matchingProviderNameIndex > 0 && providers.hasNext()) {
            BrowserAdapterProvider provider = providers.next();
            for (int providerNameIndex = 0; providerNameIndex < matchingProviderNameIndex; ++providerNameIndex) {
                if (!provider.name().equals(providerNames[providerNameIndex]) || !provider.isAvailable()) continue;
                matchingProvider = provider;
                matchingProviderNameIndex = providerNameIndex;
                continue block0;
            }
        }
        if (matchingProvider == null) {
            throw new IllegalArgumentException("No matching provider found for: " + Arrays.toString(providerNames));
        }
        return matchingProvider.getInstance(parent, style);
    }

    public BrowserAdapterProvider provider() {
        return this.provider;
    }

    public abstract Composite getBrowserWidget();

    @Override
    public Composite get() {
        return this.getBrowserWidget();
    }
}

