/*
 * Decompiled with CFR 0.152.
 */
package de.carne.mcd.jvm.classfile.decl;

import de.carne.boot.check.Check;
import de.carne.mcd.jvm.classfile.ClassName;
import de.carne.mcd.jvm.classfile.PrintBuffer;
import de.carne.mcd.jvm.classfile.PrintSeparator;
import de.carne.mcd.jvm.classfile.decl.DecodedClassSignature;
import de.carne.mcd.jvm.classfile.decl.DecodedFieldDescriptor;
import de.carne.mcd.jvm.classfile.decl.DecodedFieldSignature;
import de.carne.mcd.jvm.classfile.decl.DecodedMethodDescriptor;
import de.carne.mcd.jvm.classfile.decl.DecodedMethodSignature;
import de.carne.mcd.jvm.classfile.decl.grammar.DeclLexer;
import de.carne.mcd.jvm.classfile.decl.grammar.DeclParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.eclipse.jdt.annotation.Nullable;

public abstract class DeclDecoder {
    private static final Map<String, String> BASE_TYPE_MAP = new HashMap<String, String>();

    protected DeclDecoder() {
    }

    public static DecodedFieldDescriptor decodeFieldDescriptor(String descriptor, String classPackage) {
        return new DecodedFieldDescriptor(Objects.requireNonNull(DeclDecoder.getParser(descriptor).fieldDescriptor()), classPackage);
    }

    public static DecodedMethodDescriptor decodeMethodDescriptor(String descriptor, String classPackage) {
        return new DecodedMethodDescriptor(Objects.requireNonNull(DeclDecoder.getParser(descriptor).methodDescriptor()), classPackage);
    }

    public static DecodedClassSignature decodeClassSignature(String signature, String classPackage) {
        return new DecodedClassSignature(Objects.requireNonNull(DeclDecoder.getParser(signature).classSignature()), classPackage);
    }

    public static DecodedMethodSignature decodeMethodSignature(String signature, String classPackage) {
        return new DecodedMethodSignature(Objects.requireNonNull(DeclDecoder.getParser(signature).methodSignature()), classPackage);
    }

    public static DecodedFieldSignature decodeFieldSignature(String signature, String classPackage) {
        return new DecodedFieldSignature(Objects.requireNonNull(DeclDecoder.getParser(signature).fieldSignature()), classPackage);
    }

    protected static DeclParser getParser(String input) {
        CodePointCharStream inputStream = CharStreams.fromString((String)input);
        DeclLexer lexer = new DeclLexer((CharStream)inputStream);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        return new DeclParser((TokenStream)tokens);
    }

    protected static PrintBuffer decodeBaseType(PrintBuffer buffer, DeclParser.BaseTypeContext ctx) {
        buffer.append(Objects.requireNonNull(BASE_TYPE_MAP.get(ctx.getText())), PrintBuffer::printKeyword);
        return buffer;
    }

    protected static PrintBuffer decodeDescriptorType(DeclParser.DescriptorTypeContext ctx, String classPackage) {
        return DeclDecoder.decodeDescriptorTypeHelper(new PrintBuffer(), ctx, classPackage);
    }

    private static PrintBuffer decodeDescriptorTypeHelper(PrintBuffer buffer, DeclParser.DescriptorTypeContext ctx, String classPackage) {
        DeclParser.BaseTypeContext baseTypeCtx = ctx.baseType();
        if (baseTypeCtx != null) {
            DeclDecoder.decodeBaseType(buffer, baseTypeCtx);
        } else {
            DeclParser.ObjectTypeContext objectTypeCtx = ctx.objectType();
            if (objectTypeCtx != null) {
                String objectType = ClassName.effectiveName(ClassName.decode(objectTypeCtx.className().getText()), classPackage);
                buffer.append(objectType);
            } else {
                DeclParser.ArrayTypeContext arrayTypeCtx = ctx.arrayType();
                if (arrayTypeCtx != null) {
                    DeclDecoder.decodeDescriptorTypeHelper(buffer, arrayTypeCtx.componentType().descriptorType(), classPackage).append("[]");
                } else {
                    Check.fail();
                }
            }
        }
        return buffer;
    }

    protected static List<PrintBuffer> decodeTypeParameters(@Nullable DeclParser.TypeParametersContext ctx, String classPackage) {
        List<PrintBuffer> parameters;
        if (ctx != null) {
            parameters = new ArrayList();
            for (DeclParser.TypeParameterContext typeParameterCtx : ctx.typeParameter()) {
                parameters.add(DeclDecoder.decodeTypeParameter(typeParameterCtx, classPackage));
            }
        } else {
            parameters = Collections.emptyList();
        }
        return parameters;
    }

    private static PrintBuffer decodeTypeParameter(DeclParser.TypeParameterContext ctx, String classPackage) {
        List<DeclParser.InterfaceBoundContext> interfaceBound;
        DeclParser.ReferenceTypeSignatureContext referenceTypeSignatureCtx;
        PrintBuffer buffer = new PrintBuffer();
        buffer.append(ctx.identifier().getText());
        ArrayList<DeclParser.ReferenceTypeSignatureContext> referenceTypeSignatureCtxs = new ArrayList<DeclParser.ReferenceTypeSignatureContext>();
        DeclParser.ClassBoundContext classBoundCtx = ctx.classBound();
        if (classBoundCtx != null && (referenceTypeSignatureCtx = classBoundCtx.referenceTypeSignature()) != null && !DeclDecoder.isObject(referenceTypeSignatureCtx)) {
            referenceTypeSignatureCtxs.add(referenceTypeSignatureCtx);
        }
        if ((interfaceBound = ctx.interfaceBound()) != null) {
            for (DeclParser.InterfaceBoundContext interfaceBoundCtx : interfaceBound) {
                referenceTypeSignatureCtxs.add(interfaceBoundCtx.referenceTypeSignature());
            }
        }
        if (!referenceTypeSignatureCtxs.isEmpty()) {
            buffer.append(" extends ");
        }
        PrintSeparator printSeparator = new PrintSeparator(" & ");
        for (DeclParser.ReferenceTypeSignatureContext referenceTypeSignatureCtx2 : referenceTypeSignatureCtxs) {
            buffer.append(printSeparator.next());
            DeclDecoder.decodeReferenceTypeSignature(buffer, referenceTypeSignatureCtx2, classPackage);
        }
        return buffer;
    }

    private static PrintBuffer decodeReferenceTypeSignature(PrintBuffer buffer, DeclParser.ReferenceTypeSignatureContext ctx, String classPackage) {
        DeclParser.ClassTypeSignatureContext classTypeSignatureCtx = ctx.classTypeSignature();
        if (classTypeSignatureCtx != null) {
            DeclDecoder.decodeClassTypeSignature(buffer, classTypeSignatureCtx, classPackage);
        } else {
            DeclParser.TypeVariableSignatureContext typeVariableSignatureCtx = ctx.typeVariableSignature();
            if (typeVariableSignatureCtx != null) {
                buffer.append(typeVariableSignatureCtx.identifier().getText());
            } else {
                DeclParser.ArrayTypeSignatureContext arrayTypeSignatureCtx = ctx.arrayTypeSignature();
                if (arrayTypeSignatureCtx != null) {
                    DeclDecoder.decodeArrayTypeSignature(buffer, arrayTypeSignatureCtx, classPackage);
                } else {
                    Check.fail();
                }
            }
        }
        return buffer;
    }

    private static PrintBuffer decodeClassTypeSignature(PrintBuffer buffer, DeclParser.ClassTypeSignatureContext ctx, String classPackage) {
        String classTypeName = ClassName.effectiveName(ClassName.decode(ctx.classTypeName().getText()), classPackage);
        buffer.append(classTypeName);
        DeclDecoder.decodeTypeArguments(buffer, ctx.typeArguments(), classPackage);
        List<DeclParser.ClassTypeSignatureSuffixContext> classTypeSignatureSuffix = ctx.classTypeSignatureSuffix();
        if (classTypeSignatureSuffix != null) {
            for (DeclParser.ClassTypeSignatureSuffixContext classTypeSignatureSuffixCtx : classTypeSignatureSuffix) {
                buffer.append("." + classTypeSignatureSuffixCtx.identifier().getText());
                DeclDecoder.decodeTypeArguments(buffer, classTypeSignatureSuffixCtx.typeArguments(), classPackage);
            }
        }
        return buffer;
    }

    private static PrintBuffer decodeTypeArguments(PrintBuffer buffer, @Nullable DeclParser.TypeArgumentsContext ctx, String classPackage) {
        if (ctx != null) {
            buffer.append("<");
            PrintSeparator separator = new PrintSeparator();
            for (DeclParser.TypeArgumentContext typeArgumentCtx : ctx.typeArgument()) {
                buffer.append(separator.next());
                DeclParser.ReferenceTypeSignatureContext referenceTypeSignatureCtx = typeArgumentCtx.referenceTypeSignature();
                if (referenceTypeSignatureCtx != null) {
                    DeclParser.WildcardIndicatorContext wildcardIndicatorCtx = typeArgumentCtx.wildcardIndicator();
                    if (wildcardIndicatorCtx != null) {
                        buffer.append("? ");
                        buffer.append(("+".equals(wildcardIndicatorCtx.getText()) ? "extends" : "super") + " ", PrintBuffer::printKeyword);
                    }
                    DeclDecoder.decodeReferenceTypeSignature(buffer, referenceTypeSignatureCtx, classPackage);
                    continue;
                }
                buffer.append("?");
            }
            buffer.append(">");
        }
        return buffer;
    }

    private static PrintBuffer decodeArrayTypeSignature(PrintBuffer buffer, DeclParser.ArrayTypeSignatureContext ctx, String classPackage) {
        return DeclDecoder.decodeJavaTypeSignature(buffer, ctx.javaTypeSignature(), classPackage).append("[]");
    }

    private static PrintBuffer decodeJavaTypeSignature(PrintBuffer buffer, DeclParser.JavaTypeSignatureContext ctx, String classPackage) {
        DeclParser.ReferenceTypeSignatureContext referenceTypeSignatureCtx = ctx.referenceTypeSignature();
        if (referenceTypeSignatureCtx != null) {
            DeclDecoder.decodeReferenceTypeSignature(buffer, referenceTypeSignatureCtx, classPackage);
        } else {
            DeclParser.BaseTypeContext baseTypeCtx = ctx.baseType();
            if (baseTypeCtx != null) {
                DeclDecoder.decodeBaseType(buffer, baseTypeCtx);
            } else {
                Check.fail();
            }
        }
        return buffer;
    }

    protected static PrintBuffer decodeSuperClassSignature(DeclParser.SuperClassSignatureContext ctx, String classPackage) {
        PrintBuffer buffer = new PrintBuffer();
        DeclParser.ReferenceTypeSignatureContext referenceTypeSignatureCtx = ctx.referenceTypeSignature();
        if (!DeclDecoder.isObject(referenceTypeSignatureCtx)) {
            DeclDecoder.decodeReferenceTypeSignature(buffer, referenceTypeSignatureCtx, classPackage);
        }
        return buffer;
    }

    protected static List<PrintBuffer> decodeSuperInterfaceSignatures(@Nullable List<DeclParser.SuperInterfaceSignatureContext> superInterfaceCtxs, String classPackage) {
        List<PrintBuffer> superInterfaces;
        if (superInterfaceCtxs != null) {
            superInterfaces = new ArrayList();
            for (DeclParser.SuperInterfaceSignatureContext superInterfaceCtx : superInterfaceCtxs) {
                superInterfaces.add(DeclDecoder.decodeReferenceTypeSignature(new PrintBuffer(), superInterfaceCtx.referenceTypeSignature(), classPackage));
            }
        } else {
            superInterfaces = Collections.emptyList();
        }
        return superInterfaces;
    }

    protected static PrintBuffer decodeReferenceTypeSignature(DeclParser.ReferenceTypeSignatureContext ctx, String classPackage) {
        return DeclDecoder.decodeReferenceTypeSignature(new PrintBuffer(), ctx, classPackage);
    }

    protected static PrintBuffer decodeReturnType(DeclParser.ReturnTypeContext ctx, String classPackage) {
        return DeclDecoder.decodeJavaTypeSignature(new PrintBuffer(), ctx.javaTypeSignature(), classPackage);
    }

    protected static List<PrintBuffer> decodeJavaTypeSignatures(@Nullable List<DeclParser.JavaTypeSignatureContext> javaTypeSignatureCtxs, String classPackage) {
        List<PrintBuffer> javaTypes;
        if (javaTypeSignatureCtxs != null) {
            javaTypes = new ArrayList();
            for (DeclParser.JavaTypeSignatureContext javaTypeSignatureCtx : javaTypeSignatureCtxs) {
                javaTypes.add(DeclDecoder.decodeJavaTypeSignature(new PrintBuffer(), javaTypeSignatureCtx, classPackage));
            }
        } else {
            javaTypes = Collections.emptyList();
        }
        return javaTypes;
    }

    protected static List<PrintBuffer> decodeThrowsSignature(@Nullable List<DeclParser.ThrowsSignatureContext> throwsSignatureCtxs, String classPackage) {
        List<PrintBuffer> throwsTypes;
        if (throwsSignatureCtxs != null) {
            throwsTypes = new ArrayList();
            for (DeclParser.ThrowsSignatureContext throwsSignatureCtx : throwsSignatureCtxs) {
                DeclParser.ClassTypeSignatureContext classTypeSignatureCtx = throwsSignatureCtx.classTypeSignature();
                if (classTypeSignatureCtx != null) {
                    throwsTypes.add(DeclDecoder.decodeClassTypeSignature(new PrintBuffer(), classTypeSignatureCtx, classPackage));
                    continue;
                }
                DeclParser.TypeVariableSignatureContext typeVariableSignatureCtx = throwsSignatureCtx.typeVariableSignature();
                if (typeVariableSignatureCtx == null) continue;
                throwsTypes.add(new PrintBuffer().append(typeVariableSignatureCtx.identifier().getText()));
            }
        } else {
            throwsTypes = Collections.emptyList();
        }
        return throwsTypes;
    }

    private static boolean isObject(DeclParser.ReferenceTypeSignatureContext ctx) {
        return "Ljava/lang/Object;".equals(ctx.getText());
    }

    static {
        BASE_TYPE_MAP.put("B", "byte");
        BASE_TYPE_MAP.put("C", "char");
        BASE_TYPE_MAP.put("D", "double");
        BASE_TYPE_MAP.put("F", "float");
        BASE_TYPE_MAP.put("I", "int");
        BASE_TYPE_MAP.put("J", "long");
        BASE_TYPE_MAP.put("S", "short");
        BASE_TYPE_MAP.put("V", "void");
        BASE_TYPE_MAP.put("Z", "boolean");
    }
}

