/*
 * Decompiled with CFR 0.152.
 */
package de.carne.mcd.jvm.classfile.constant;

import de.carne.mcd.jvm.classfile.ClassInfo;
import de.carne.mcd.jvm.classfile.PrintBuffer;
import de.carne.mcd.jvm.classfile.PrintSeparator;
import de.carne.mcd.jvm.classfile.constant.AbstractRefConstant;
import de.carne.mcd.jvm.classfile.decl.DeclDecoder;
import de.carne.mcd.jvm.classfile.decl.DecodedMethodDescriptor;

public class MethodRefConstant
extends AbstractRefConstant {
    public static final int TAG = 10;

    public MethodRefConstant(ClassInfo classInfo, int classIndex, int nameAndTypeIndex) {
        super(classInfo, classIndex, nameAndTypeIndex);
    }

    @Override
    protected String decodeNameAndDescriptor(String className, String name, String descriptor, String classPackage) {
        DecodedMethodDescriptor method = DeclDecoder.decodeMethodDescriptor(descriptor, classPackage);
        StringBuilder buffer = new StringBuilder();
        buffer.append(method.returnType()).append(' ').append(className).append('.').append(name).append('(');
        PrintSeparator separator = new PrintSeparator();
        for (PrintBuffer parameter : method.parameterTypes()) {
            buffer.append(separator.next());
            buffer.append(parameter);
        }
        buffer.append(')');
        return buffer.toString();
    }
}

