/*
 * Decompiled with CFR 0.152.
 */
package de.carne.mcd.jvm.classfile.constant;

import de.carne.boot.check.Check;
import de.carne.mcd.jvm.classfile.ClassContext;
import de.carne.mcd.jvm.classfile.ClassInfo;
import de.carne.mcd.jvm.classfile.ClassName;
import de.carne.mcd.jvm.classfile.ClassPrinter;
import de.carne.mcd.jvm.classfile.constant.ClassConstant;
import de.carne.mcd.jvm.classfile.constant.Constant;
import de.carne.mcd.jvm.classfile.constant.NameAndTypeConstant;
import java.io.IOException;

abstract class AbstractRefConstant
extends Constant {
    private final int classIndex;
    private final int nameAndTypeIndex;

    AbstractRefConstant(ClassInfo classInfo, int classIndex, int nameAndTypeIndex) {
        super(classInfo);
        this.classIndex = classIndex;
        this.nameAndTypeIndex = nameAndTypeIndex;
    }

    @Override
    public void print(ClassPrinter out, ClassContext context) throws IOException {
        Check.fail();
    }

    @Override
    public String resolveSymbol() throws IOException {
        String classPackage = this.classInfo.thisClass().getPackageName();
        String className = ClassName.fromConstant(this.classInfo.resolveConstant(this.classIndex, ClassConstant.class)).getEffectiveName(classPackage);
        NameAndTypeConstant nameAndTypeValue = this.classInfo.resolveConstant(this.nameAndTypeIndex, NameAndTypeConstant.class);
        String name = nameAndTypeValue.getNameValue();
        String descriptor = nameAndTypeValue.getDescriptorValue();
        return this.decodeNameAndDescriptor(className, name, descriptor, classPackage);
    }

    protected abstract String decodeNameAndDescriptor(String var1, String var2, String var3, String var4);

    public String toString() {
        return "#" + this.classIndex + ":" + this.nameAndTypeIndex;
    }
}

