/*
 * Decompiled with CFR 0.152.
 */
package de.carne.mcd.jvm.classfile.constant;

import de.carne.boot.check.Check;
import de.carne.mcd.jvm.classfile.ClassContext;
import de.carne.mcd.jvm.classfile.ClassInfo;
import de.carne.mcd.jvm.classfile.ClassPrinter;
import de.carne.mcd.jvm.classfile.constant.Constant;
import de.carne.mcd.jvm.classfile.constant.NameAndTypeConstant;
import java.io.IOException;

abstract class AbstractDynamicConstant
extends Constant {
    private final int bootstrapMethodAttrIndex;
    private final int nameAndTypeIndex;

    AbstractDynamicConstant(ClassInfo classInfo, int bootstrapMethodAttrIndex, int nameAndTypeIndex) {
        super(classInfo);
        this.bootstrapMethodAttrIndex = bootstrapMethodAttrIndex;
        this.nameAndTypeIndex = nameAndTypeIndex;
    }

    @Override
    public void print(ClassPrinter out, ClassContext context) throws IOException {
        Check.fail();
    }

    @Override
    public String resolveSymbol() throws IOException {
        NameAndTypeConstant nameAndTypeValue = this.classInfo.resolveConstant(this.nameAndTypeIndex, NameAndTypeConstant.class);
        String name = nameAndTypeValue.getNameValue();
        String descriptor = nameAndTypeValue.getDescriptorValue();
        return this.decodeNameAndDescriptor("bootstrapMethod#" + this.bootstrapMethodAttrIndex, name, descriptor, this.classInfo.thisClass().getPackageName());
    }

    protected abstract String decodeNameAndDescriptor(String var1, String var2, String var3, String var4);

    public String toString() {
        return "#" + this.bootstrapMethodAttrIndex + ":" + this.nameAndTypeIndex;
    }
}

