/*
 * Decompiled with CFR 0.152.
 */
package de.carne.mcd.jvm.classfile.bytecode;

import de.carne.mcd.io.MCDInputBuffer;
import de.carne.mcd.io.MCDOutputBuffer;
import de.carne.mcd.jvm.classfile.bytecode.IntOperandDecoder;
import de.carne.mcd.jvm.classfile.bytecode.OperandType;
import de.carne.text.HexFormat;
import java.io.IOException;

public enum IntOperandType implements OperandType
{
    IMMEDIATE_VALUE((pc, operand, out) -> out.printValue(Integer.toString(operand))),
    BRANCH((pc, operand, out) -> out.printValue(operand >= 0 ? "+" : "").printValue(Integer.toString(operand)).print(" ").printComment("// ").printComment(HexFormat.LOWER_CASE.format(pc + operand)));

    private final IntOperandDecoder decoder;

    private IntOperandType(IntOperandDecoder decoder) {
        this.decoder = decoder;
    }

    @Override
    public char type() {
        return 'I';
    }

    @Override
    public void decode(int pc, MCDInputBuffer buffer, MCDOutputBuffer out) throws IOException {
        this.decoder.decode(pc, buffer.decodeI32(), out);
    }
}

