/*
 * Decompiled with CFR 0.152.
 */
package de.carne.mcd.jvm.classfile.bytecode;

import de.carne.mcd.instruction.Instruction;
import de.carne.mcd.instruction.InstructionOpcode;
import de.carne.mcd.io.MCDInputBuffer;
import de.carne.mcd.io.MCDOutputBuffer;
import de.carne.mcd.jvm.classfile.bytecode.ByteOperandType;
import de.carne.mcd.jvm.classfile.bytecode.IntOperandType;
import de.carne.mcd.jvm.classfile.bytecode.LookupswitchOperandDecoder;
import de.carne.mcd.jvm.classfile.bytecode.OperandType;
import de.carne.mcd.jvm.classfile.bytecode.ShortOperandType;
import de.carne.mcd.jvm.classfile.bytecode.TableswitchOperandDecoder;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;

public class BytecodeInstruction
implements Instruction {
    private final String mnemonic;
    private final OperandType[] operands;

    public BytecodeInstruction(String mnemonic, OperandType[] operands) {
        this.mnemonic = mnemonic;
        this.operands = operands;
    }

    static BytecodeInstruction load(DataInput in) throws IOException {
        char operandType;
        String mnemonic = in.readUTF();
        ArrayList<OperandType> operands = new ArrayList<OperandType>();
        do {
            operandType = in.readChar();
            String operandName = in.readUTF();
            switch (operandType) {
                case 't': {
                    operands.add(new TableswitchOperandDecoder());
                    break;
                }
                case 'l': {
                    operands.add(new LookupswitchOperandDecoder());
                    break;
                }
                case 'B': {
                    operands.add(ByteOperandType.valueOf(operandName));
                    break;
                }
                case 'S': {
                    operands.add(ShortOperandType.valueOf(operandName));
                    break;
                }
                case 'I': {
                    operands.add(IntOperandType.valueOf(operandName));
                    break;
                }
                case '\u0000': {
                    break;
                }
                default: {
                    throw new IOException("Unrecognized operand type: " + operandType + ":" + operandName);
                }
            }
        } while (operandType != '\u0000');
        return new BytecodeInstruction(mnemonic, operands.toArray(new OperandType[operands.size()]));
    }

    public void save(DataOutput out) throws IOException {
        out.writeUTF(this.mnemonic);
        for (OperandType operand : this.operands) {
            out.writeChar(operand.type());
            out.writeUTF(operand.name());
        }
        out.writeChar(0);
        out.writeUTF("");
    }

    public void decode(long ip, InstructionOpcode opcode, MCDInputBuffer in, MCDOutputBuffer out) throws IOException {
        if (this.operands.length > 0) {
            out.printKeyword(this.mnemonic).print(" ");
            for (OperandType operand : this.operands) {
                operand.decode((int)ip, in, out);
            }
            out.println();
        } else {
            out.printlnKeyword(this.mnemonic);
        }
    }
}

