/*
 * Decompiled with CFR 0.152.
 */
package de.carne.mcd.jvm.classfile.bytecode;

import de.carne.boot.logging.Log;
import de.carne.mcd.MachineCodeDecoder;
import de.carne.mcd.instruction.InstructionIndex;
import de.carne.mcd.io.MCDInputBuffer;
import de.carne.mcd.io.MCDOutputBuffer;
import de.carne.mcd.jvm.classfile.ClassInfo;
import de.carne.mcd.jvm.classfile.bytecode.BytecodeInstructionIndex;
import de.carne.text.HexFormat;
import de.carne.util.Late;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import java.util.Optional;

public class BytecodeDecoder
extends MachineCodeDecoder {
    private static final Log LOG = new Log();
    public static final String NAME = "Java bytecode";
    private static final Late<InstructionIndex> BYTECODE_INSTRUCTION_INDEX_HOLDER = new Late();
    private final ClassInfo classInfo;

    public BytecodeDecoder(ClassInfo classInfo) {
        super(NAME, ByteOrder.BIG_ENDIAN, Long.MAX_VALUE);
        this.classInfo = classInfo;
    }

    public ClassInfo getClassInfo() {
        return this.classInfo;
    }

    protected long decode0(MCDInputBuffer in, MCDOutputBuffer out, long offset, long limit) throws IOException {
        InstructionIndex.LookupResult lookupResult;
        out.printComment("// max_stack: ").printlnComment(Integer.toString(Short.toUnsignedInt(in.decodeI16())));
        out.printComment("// max_locals: ").printlnComment(Integer.toString(Short.toUnsignedInt(in.decodeI16())));
        long codeLength = Integer.toUnsignedLong(in.decodeI32());
        MCDInputBuffer codeBuffer = new MCDInputBuffer((ReadableByteChannel)in.slice(codeLength), this.byteOrder());
        InstructionIndex instructionIndex = BytecodeDecoder.getBytecodeInstructionIndex();
        long pc = offset;
        codeBuffer.setAutoCommit(false);
        while ((lookupResult = instructionIndex.lookupNextInstruction(codeBuffer, false)) != null) {
            String pcString = HexFormat.LOWER_CASE.format((short)pc) + ":";
            out.printLabel(pcString).print(" ");
            try {
                lookupResult.decode(pc, codeBuffer, out);
                pc = offset + codeBuffer.getTotalRead();
            }
            catch (IOException e) {
                String opcodeString = lookupResult.opcode().toString();
                LOG.warning((Throwable)e, "Decode failure at {0} for opcode: {1}", new Object[]{pcString, opcodeString});
                out.printlnError(opcodeString);
            }
            codeBuffer.commit();
        }
        return in.getTotalRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InstructionIndex getBytecodeInstructionIndex() throws IOException {
        InstructionIndex instructionIndex;
        Late<InstructionIndex> late = BYTECODE_INSTRUCTION_INDEX_HOLDER;
        synchronized (late) {
            Optional instructionIndexHolder = BYTECODE_INSTRUCTION_INDEX_HOLDER.getOptional();
            instructionIndex = instructionIndexHolder.isPresent() ? (InstructionIndex)instructionIndexHolder.get() : (InstructionIndex)BYTECODE_INSTRUCTION_INDEX_HOLDER.set((Object)BytecodeInstructionIndex.open());
        }
        return instructionIndex;
    }
}

