/*
 * Decompiled with CFR 0.152.
 */
package de.carne.mcd.jvm.classfile.attribute.annotation;

import de.carne.mcd.jvm.classfile.ClassContext;
import de.carne.mcd.jvm.classfile.ClassInfo;
import de.carne.mcd.jvm.classfile.ClassPrinter;
import de.carne.mcd.jvm.classfile.PrintSeparator;
import de.carne.mcd.jvm.classfile.attribute.annotation.AnnotationElementValue;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class ArrayAnnotationElement
extends AnnotationElementValue {
    public static final int TAG = 91;
    private final List<AnnotationElementValue> elementValues;

    public ArrayAnnotationElement(ClassInfo classInfo, List<AnnotationElementValue> elementValues) {
        super(classInfo);
        this.elementValues = Collections.unmodifiableList(elementValues);
    }

    @Override
    public void print(ClassPrinter out, ClassContext context) throws IOException {
        int elementValuesSize = this.elementValues.size();
        if (elementValuesSize > 1) {
            out.print("{ ");
        }
        PrintSeparator separator = new PrintSeparator();
        for (AnnotationElementValue elementValue : this.elementValues) {
            separator.print(out, context);
            elementValue.print(out, context);
        }
        if (elementValuesSize > 1) {
            out.print(" }");
        }
    }
}

