/*
 * Decompiled with CFR 0.152.
 */
package de.carne.mcd.jvm.classfile.attribute.annotation;

import de.carne.mcd.jvm.classfile.ClassContext;
import de.carne.mcd.jvm.classfile.ClassInfo;
import de.carne.mcd.jvm.classfile.ClassInfoElement;
import de.carne.mcd.jvm.classfile.ClassPrinter;
import de.carne.mcd.jvm.classfile.PrintSeparator;
import de.carne.mcd.jvm.classfile.attribute.annotation.AnnotationElement;
import de.carne.mcd.jvm.classfile.constant.Utf8Constant;
import de.carne.mcd.jvm.classfile.decl.DeclDecoder;
import de.carne.mcd.jvm.classfile.decl.DecodedFieldDescriptor;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class Annotation
extends ClassInfoElement {
    private final int typeIndex;
    private final List<AnnotationElement> elements;

    public Annotation(ClassInfo classInfo, int typeIndex, List<AnnotationElement> elements) {
        super(classInfo);
        this.typeIndex = typeIndex;
        this.elements = Collections.unmodifiableList(elements);
    }

    @Override
    public void print(ClassPrinter out, ClassContext context) throws IOException {
        String typeName = this.classInfo.resolveConstant(this.typeIndex, Utf8Constant.class).getValue();
        DecodedFieldDescriptor annotationType = DeclDecoder.decodeFieldDescriptor(typeName, this.classInfo.thisClass().getPackageName());
        out.printLabel("@");
        annotationType.type().print(out, ClassContext.ANNOTATION);
        int elementsSize = this.elements.size();
        if (elementsSize > 0) {
            out.print("(");
            PrintSeparator separator = new PrintSeparator();
            for (AnnotationElement element : this.elements) {
                separator.print(out, context);
                element.print(out, context);
            }
            out.print(")");
        }
        if (context.isOneOf(ClassContext.CLASS, ClassContext.METHOD)) {
            out.println();
        } else if (context != ClassContext.ANNOTATION) {
            out.print(" ");
        }
    }
}

