/*
 * Decompiled with CFR 0.152.
 */
package de.carne.mcd.jvm.classfile.attribute;

import de.carne.boot.check.Check;
import de.carne.mcd.jvm.classfile.ClassContext;
import de.carne.mcd.jvm.classfile.ClassInfo;
import de.carne.mcd.jvm.classfile.ClassPrinter;
import de.carne.mcd.jvm.classfile.attribute.Attribute;
import de.carne.mcd.jvm.classfile.attribute.annotation.TypeAnnotation;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public abstract class RuntimeTypeAnnotationsAttribute
extends Attribute {
    private final List<TypeAnnotation> annotations;

    protected RuntimeTypeAnnotationsAttribute(ClassInfo classInfo, List<TypeAnnotation> annotations) {
        super(classInfo);
        this.annotations = Collections.unmodifiableList(annotations);
    }

    @Override
    public void print(ClassPrinter out, ClassContext context) throws IOException {
        Check.fail();
    }

    public List<TypeAnnotation> resolveTypeAnnotations(int targetType) {
        return this.annotations.stream().filter(annotation -> annotation.matchTargetType(targetType)).collect(Collectors.toList());
    }
}

