/*
 * Decompiled with CFR 0.152.
 */
package de.carne.mcd.jvm.classfile.attribute;

import de.carne.mcd.jvm.classfile.ClassContext;
import de.carne.mcd.jvm.classfile.ClassInfo;
import de.carne.mcd.jvm.classfile.ClassPrinter;
import de.carne.mcd.jvm.classfile.PrintSeparator;
import de.carne.mcd.jvm.classfile.attribute.Attribute;
import de.carne.mcd.jvm.classfile.constant.ClassConstant;
import java.io.IOException;

public class ExceptionsAttribute
extends Attribute {
    public static final String NAME = "Exceptions";
    private final int[] exceptions;

    public ExceptionsAttribute(ClassInfo classInfo, int[] exceptions) {
        super(classInfo);
        this.exceptions = exceptions;
    }

    @Override
    public void print(ClassPrinter out, ClassContext context) throws IOException {
        if (this.exceptions.length > 0) {
            out.print(" ").printKeyword("throws").print(" ");
            PrintSeparator separator = new PrintSeparator();
            for (int exception : this.exceptions) {
                separator.print(out, context);
                this.classInfo.resolveConstant(exception, ClassConstant.class).print(out, context);
            }
        }
    }
}

