/*
 * Decompiled with CFR 0.152.
 */
package de.carne.mcd.jvm.classfile.attribute;

import de.carne.mcd.jvm.classfile.ClassContext;
import de.carne.mcd.jvm.classfile.ClassPrinter;
import de.carne.mcd.jvm.classfile.attribute.Attribute;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class Attributes {
    private Attributes() {
    }

    public static <T extends Attribute> List<T> resolveAttributes(List<Attribute> attributes, Class<T> type) {
        return attributes.stream().filter(a -> type.isAssignableFrom(a.getClass())).map(type::cast).collect(Collectors.toList());
    }

    public static <T extends Attribute> T resolveUniqueAttribute(List<Attribute> attributes, Class<T> type) throws IOException {
        List<T> resolved = Attributes.resolveAttributes(attributes, type);
        int resolvedCount = resolved.size();
        if (resolvedCount != 1) {
            throw new IOException("Unexpected number of '" + type.getSimpleName() + "' attributes: " + resolvedCount);
        }
        return (T)((Attribute)resolved.get(0));
    }

    public static <T extends Attribute> Optional<T> resolveOptionalAttribute(List<Attribute> attributes, Class<T> type) throws IOException {
        List<T> resolved = Attributes.resolveAttributes(attributes, type);
        int resolvedCount = resolved.size();
        if (resolvedCount > 1) {
            throw new IOException("Unexpected number of '" + type.getSimpleName() + "' attributes: " + resolvedCount);
        }
        return resolvedCount == 0 ? Optional.empty() : Optional.of(resolved.get(0));
    }

    public static void print(List<? extends Attribute> attributes, ClassPrinter out, ClassContext context) throws IOException {
        for (Attribute attribute : attributes) {
            attribute.print(out, context);
        }
    }

    public static void print(Optional<? extends Attribute> attribute, ClassPrinter out, ClassContext context) throws IOException {
        if (attribute.isPresent()) {
            attribute.get().print(out, context);
        }
    }
}

