/*
 * Decompiled with CFR 0.152.
 */
package de.carne.mcd.jvm.classfile;

import de.carne.mcd.jvm.classfile.ClassContext;
import de.carne.mcd.jvm.classfile.ClassPrinter;
import de.carne.mcd.jvm.classfile.Printable;
import de.carne.util.Strings;
import java.io.IOException;
import java.util.Deque;
import java.util.LinkedList;

public final class PrintBuffer
implements Printable {
    private final Deque<Entry> entries = new LinkedList<Entry>();

    public static void print(String token, ClassPrinter out, ClassContext context) throws IOException {
        if (context == ClassContext.ANNOTATION) {
            out.printLabel(token);
        } else {
            out.print(token);
        }
    }

    public static void printKeyword(String token, ClassPrinter out, ClassContext context) throws IOException {
        if (context == ClassContext.ANNOTATION) {
            out.printLabel(token);
        } else {
            out.printKeyword(token);
        }
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public PrintBuffer append(String token) {
        if (Strings.notEmpty((String)token)) {
            this.entries.add(new Entry(token, PrintBuffer::print));
        }
        return this;
    }

    public PrintBuffer append(String token, Printer printer) {
        if (Strings.notEmpty((String)token)) {
            this.entries.add(new Entry(token, printer));
        }
        return this;
    }

    @Override
    public void print(ClassPrinter out, ClassContext context) throws IOException {
        for (Entry entry : this.entries) {
            entry.print(out, context);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (Entry entry : this.entries) {
            buffer.append(entry.toString());
        }
        return buffer.toString();
    }

    @FunctionalInterface
    public static interface Printer {
        public void print(String var1, ClassPrinter var2, ClassContext var3) throws IOException;
    }

    private class Entry
    implements Printable {
        private final String token;
        private final Printer printer;

        Entry(String token, Printer printer) {
            this.token = token;
            this.printer = printer;
        }

        @Override
        public void print(ClassPrinter out, ClassContext context) throws IOException {
            this.printer.print(this.token, out, context);
        }

        public String toString() {
            return this.token;
        }
    }
}

