/*
 * Decompiled with CFR 0.152.
 */
package de.carne.mcd.jvm.classfile;

import de.carne.boot.check.Check;
import de.carne.mcd.jvm.classfile.ClassContext;
import de.carne.mcd.jvm.classfile.ClassInfo;
import de.carne.mcd.jvm.classfile.ClassInfoElement;
import de.carne.mcd.jvm.classfile.ClassPrinter;
import de.carne.mcd.jvm.classfile.FieldInfo;
import de.carne.mcd.jvm.classfile.NameDescriptorIndex;
import de.carne.mcd.jvm.classfile.attribute.Attribute;
import de.carne.mcd.jvm.classfile.constant.Utf8Constant;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

class Field
extends ClassInfoElement
implements FieldInfo {
    private final int accessFlags;
    private final NameDescriptorIndex nameDescriptorIndex;
    private final List<Attribute> attributes;

    Field(ClassInfo classInfo, int accessFlags, int nameIndex, int descriptorIndex, List<Attribute> attributes) {
        super(classInfo);
        this.accessFlags = accessFlags;
        this.nameDescriptorIndex = new NameDescriptorIndex(nameIndex, descriptorIndex);
        this.attributes = Collections.unmodifiableList(attributes);
    }

    @Override
    public int accessFlags() {
        return this.accessFlags;
    }

    @Override
    public String descriptor() throws IOException {
        return this.classInfo.resolveConstant(this.nameDescriptorIndex.descriptorIndex(), Utf8Constant.class).getValue();
    }

    @Override
    public String name() throws IOException {
        return this.classInfo.resolveConstant(this.nameDescriptorIndex.nameIndex(), Utf8Constant.class).getValue();
    }

    @Override
    public List<Attribute> attributes() {
        return this.attributes;
    }

    @Override
    public void print(ClassPrinter out, ClassContext context) throws IOException {
        Check.fail();
    }

    public String toString() {
        return this.nameDescriptorIndex.toString();
    }
}

