/*
 * Decompiled with CFR 0.152.
 */
package de.carne.mcd.jvm.classfile;

import de.carne.mcd.jvm.classfile.ClassInfo;
import de.carne.mcd.jvm.classfile.ClassName;

public final class ClassUtil {
    private ClassUtil() {
    }

    public static boolean isPublic(ClassInfo classInfo) {
        return ClassUtil.isPublic(classInfo.accessFlags());
    }

    public static boolean isPublic(int accessFlags) {
        return (accessFlags & 1) == 1;
    }

    public static boolean isPrivate(ClassInfo classInfo) {
        return ClassUtil.isPrivate(classInfo.accessFlags());
    }

    public static boolean isPrivate(int accessFlags) {
        return (accessFlags & 2) == 2;
    }

    public static boolean isFinal(ClassInfo classInfo) {
        return ClassUtil.isFinal(classInfo.accessFlags());
    }

    public static boolean isFinal(int accessFlags) {
        return (accessFlags & 0x10) == 16;
    }

    public static boolean isInterface(ClassInfo classInfo) {
        return ClassUtil.isInterface(classInfo.accessFlags());
    }

    public static boolean isInterface(int accessFlags) {
        return (accessFlags & 0xA200) == 512;
    }

    public static boolean isAbstract(ClassInfo classInfo) {
        return ClassUtil.isAbstract(classInfo.accessFlags());
    }

    public static boolean isAbstract(int accessFlags) {
        return (accessFlags & 0x600) == 1024;
    }

    public static boolean isAnnotation(ClassInfo classInfo) {
        return ClassUtil.isAnnotation(classInfo.accessFlags());
    }

    public static boolean isAnnotation(int accessFlags) {
        return (accessFlags & 0x2000) == 8192;
    }

    public static boolean isEnum(ClassInfo classInfo) {
        return ClassUtil.isEnum(classInfo.accessFlags());
    }

    public static boolean isEnum(int accessFlags) {
        return (accessFlags & 0x4000) == 16384;
    }

    public static boolean isPackageInfo(ClassInfo classInfo) {
        return ClassUtil.isPackageInfo(classInfo.thisClass());
    }

    public static boolean isPackageInfo(ClassName className) {
        return className.isPackageInfo();
    }

    public static boolean isModuleInfo(ClassInfo classInfo) {
        return ClassUtil.isModuleInfo(classInfo.thisClass());
    }

    public static boolean isModuleInfo(ClassName className) {
        return className.isModuleInfo();
    }
}

