/*
 * Decompiled with CFR 0.152.
 */
package de.carne.mcd.jvm.classfile;

import de.carne.mcd.jvm.classfile.constant.NameConstant;
import java.io.IOException;
import org.eclipse.jdt.annotation.Nullable;

public class ClassName {
    private static final String JAVA_LANG_PACKAGE = Object.class.getPackage().getName();
    private final String fullName;
    private final String packageName;
    private final String simpleName;

    private ClassName(String fullName, String packageName, String simpleName) {
        this.fullName = fullName;
        this.packageName = packageName;
        this.simpleName = simpleName;
    }

    public static String decode(String internal) {
        return internal.replace('/', '.');
    }

    public static String effectiveName(String name, String classPackage) {
        String effectiveName = ClassName.isPackage(name, classPackage) ? name.substring(classPackage.length() + 1) : (ClassName.isPackage(name, JAVA_LANG_PACKAGE) ? name.substring(JAVA_LANG_PACKAGE.length() + 1) : name);
        return effectiveName;
    }

    private static boolean isPackage(String name, String classPackage) {
        int classPackageLength = classPackage.length();
        return name.startsWith(classPackage) && name.lastIndexOf(46) == classPackageLength;
    }

    public static ClassName fromInternalName(String internal) {
        String simpleName;
        String packageName;
        String name = ClassName.decode(internal);
        int baseIndex = name.lastIndexOf(46);
        if (baseIndex >= 0) {
            packageName = name.substring(0, baseIndex);
            simpleName = name.substring(baseIndex + 1);
        } else {
            packageName = "";
            simpleName = name;
        }
        return new ClassName(name, packageName, simpleName);
    }

    public static ClassName fromConstant(@Nullable NameConstant nameConstant) throws IOException {
        return ClassName.fromInternalName(nameConstant != null ? nameConstant.getNameValue() : Object.class.getName());
    }

    public boolean isPackageInfo() {
        return this.simpleName.equals("package-info");
    }

    public boolean isModuleInfo() {
        return this.simpleName.equals("module-info");
    }

    public boolean isObject() {
        return Object.class.getName().equals(this.fullName);
    }

    public boolean isEnum() {
        return Enum.class.getName().equals(this.fullName);
    }

    public String getName() {
        return this.fullName;
    }

    public String getEffectiveName(String classPackage) {
        return this.packageName.equals(classPackage) || this.packageName.equals(JAVA_LANG_PACKAGE) ? this.simpleName : this.fullName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String toString() {
        return this.fullName;
    }
}

