/*
 * Decompiled with CFR 0.152.
 */
package de.carne.jfx.messagebox;

import de.carne.jfx.FXPlatform;
import de.carne.jfx.StageController;
import de.carne.jfx.messagebox.I18N;
import de.carne.jfx.messagebox.MessageBoxImages;
import de.carne.jfx.messagebox.MessageBoxResult;
import de.carne.jfx.messagebox.MessageBoxStyle;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.ToggleButton;
import javafx.scene.image.ImageView;
import javafx.stage.Stage;

public class MessageBoxController
extends StageController {
    private MessageBoxResult resultCmd1 = MessageBoxResult.NONE;
    private MessageBoxResult resultCmd2 = MessageBoxResult.NONE;
    private MessageBoxResult resultCmd3 = MessageBoxResult.NONE;
    private MessageBoxResult result = MessageBoxResult.NONE;
    @FXML
    ImageView ctlIcon;
    @FXML
    Label ctlMessage;
    @FXML
    TextArea ctlDetailsText;
    @FXML
    ToggleButton ctlDetailsButton;
    @FXML
    Label ctlDetailsLabel;
    @FXML
    Button ctlCmd1Button;
    @FXML
    Button ctlCmd2Button;
    @FXML
    Button ctlCmd3Button;

    @FXML
    void onToggleDetails(ActionEvent evt) {
        this.setDetailsExpanded(this.ctlDetailsButton.isSelected());
    }

    @FXML
    void onButton1(ActionEvent evt) {
        this.result = this.resultCmd1;
        this.getStage().close();
    }

    @FXML
    void onButton2(ActionEvent evt) {
        this.result = this.resultCmd2;
        this.getStage().close();
    }

    @FXML
    void onButton3(ActionEvent evt) {
        this.result = this.resultCmd3;
        this.getStage().close();
    }

    @Override
    protected void setupStage(Stage controllerStage) throws IOException {
        super.setupStage(controllerStage);
        controllerStage.setTitle(I18N.formatSTR_MESSAGEBOX_TITLE(new Object[0]));
        this.ctlDetailsButton.managedProperty().bind((ObservableValue)this.ctlDetailsButton.visibleProperty());
        this.ctlDetailsLabel.managedProperty().bind((ObservableValue)this.ctlDetailsLabel.visibleProperty());
        this.ctlDetailsText.managedProperty().bind((ObservableValue)this.ctlDetailsText.visibleProperty());
        this.ctlCmd1Button.managedProperty().bind((ObservableValue)this.ctlCmd1Button.visibleProperty());
        this.ctlCmd2Button.managedProperty().bind((ObservableValue)this.ctlCmd2Button.visibleProperty());
        this.ctlCmd3Button.managedProperty().bind((ObservableValue)this.ctlCmd3Button.visibleProperty());
    }

    private void setDetailsExpanded(boolean expanded) {
        this.ctlDetailsButton.setSelected(expanded);
        this.ctlDetailsButton.setText(expanded ? I18N.formatSTR_DETAILS_EXPANDED_BUTTON(new Object[0]) : I18N.formatSTR_DETAILS_COLLAPSED_BUTTON(new Object[0]));
        this.ctlDetailsText.setVisible(expanded);
        this.getStage().sizeToScene();
    }

    public void beginMessageBox(String message, Throwable details, MessageBoxStyle ... styles) {
        this.ctlMessage.setText(message);
        String detailsString = this.formatDetails(details);
        if (detailsString != null) {
            this.ctlDetailsText.setText(detailsString);
        } else {
            this.ctlDetailsButton.setVisible(false);
            this.ctlDetailsLabel.setVisible(false);
        }
        this.setDetailsExpanded(false);
        block10: for (MessageBoxStyle style : styles) {
            switch (style) {
                case ICON_INFO: {
                    this.getStage().getIcons().addAll(FXPlatform.stageIcons(MessageBoxImages.getImages(MessageBoxStyle.ICON_INFO)));
                    this.ctlIcon.setImage(MessageBoxImages.getImage(MessageBoxStyle.ICON_INFO));
                    continue block10;
                }
                case ICON_WARNING: {
                    this.getStage().getIcons().addAll(FXPlatform.stageIcons(MessageBoxImages.getImages(MessageBoxStyle.ICON_WARNING)));
                    this.ctlIcon.setImage(MessageBoxImages.getImage(MessageBoxStyle.ICON_WARNING));
                    continue block10;
                }
                case ICON_ERROR: {
                    this.getStage().getIcons().addAll(FXPlatform.stageIcons(MessageBoxImages.getImages(MessageBoxStyle.ICON_ERROR)));
                    this.ctlIcon.setImage(MessageBoxImages.getImage(MessageBoxStyle.ICON_ERROR));
                    continue block10;
                }
                case ICON_QUESTION: {
                    this.getStage().getIcons().addAll(FXPlatform.stageIcons(MessageBoxImages.getImages(MessageBoxStyle.ICON_QUESTION)));
                    this.ctlIcon.setImage(MessageBoxImages.getImage(MessageBoxStyle.ICON_QUESTION));
                    continue block10;
                }
                case BUTTON_OK: {
                    this.ctlCmd1Button.setText(I18N.formatSTR_OK_BUTTON(new Object[0]));
                    this.ctlCmd1Button.setDefaultButton(true);
                    this.resultCmd1 = MessageBoxResult.OK;
                    this.ctlCmd2Button.setVisible(false);
                    this.ctlCmd3Button.setVisible(false);
                    continue block10;
                }
                case BUTTON_OK_CANCEL: {
                    this.ctlCmd1Button.setText(I18N.formatSTR_CANCEL_BUTTON(new Object[0]));
                    this.ctlCmd1Button.setCancelButton(true);
                    this.resultCmd1 = MessageBoxResult.CANCEL;
                    this.ctlCmd2Button.setText(I18N.formatSTR_OK_BUTTON(new Object[0]));
                    this.ctlCmd2Button.setDefaultButton(true);
                    this.resultCmd2 = MessageBoxResult.OK;
                    this.ctlCmd3Button.setVisible(false);
                    continue block10;
                }
                case BUTTON_YES_NO: {
                    this.ctlCmd1Button.setText(I18N.formatSTR_NO_BUTTON(new Object[0]));
                    this.ctlCmd1Button.setCancelButton(true);
                    this.resultCmd1 = MessageBoxResult.NO;
                    this.ctlCmd2Button.setText(I18N.formatSTR_YES_BUTTON(new Object[0]));
                    this.ctlCmd2Button.setDefaultButton(true);
                    this.resultCmd2 = MessageBoxResult.YES;
                    this.ctlCmd3Button.setVisible(false);
                    continue block10;
                }
                case BUTTON_YES_NO_CANCEL: {
                    this.ctlCmd1Button.setText(I18N.formatSTR_CANCEL_BUTTON(new Object[0]));
                    this.ctlCmd1Button.setCancelButton(true);
                    this.resultCmd1 = MessageBoxResult.CANCEL;
                    this.ctlCmd2Button.setText(I18N.formatSTR_NO_BUTTON(new Object[0]));
                    this.resultCmd2 = MessageBoxResult.NO;
                    this.ctlCmd3Button.setText(I18N.formatSTR_YES_BUTTON(new Object[0]));
                    this.resultCmd3 = MessageBoxResult.YES;
                    continue block10;
                }
                default: {
                    throw new RuntimeException("Unexpected style: " + (Object)((Object)style));
                }
            }
        }
        this.getStage().sizeToScene();
    }

    public MessageBoxResult getResult() {
        return this.result;
    }

    private String formatDetails(Throwable details) {
        String detailsString = null;
        if (details != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            details.printStackTrace(printWriter);
            detailsString = stringWriter.toString();
        }
        return detailsString;
    }
}

