/*
 * Decompiled with CFR 0.152.
 */
package de.carne.jfx.logview;

import de.carne.jfx.ImageViewTableCell;
import de.carne.jfx.StageController;
import de.carne.jfx.logview.LogRecordModel;
import de.carne.util.logging.Log;
import de.carne.util.logging.LogBufferHandler;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Callback;

public class LogViewController
extends StageController {
    private static final Log LOG = new Log(LogViewController.class);
    private final Handler logHandler = new Handler(){

        @Override
        public void publish(LogRecord record) {
            LogViewController.this.publishLogRecord(record);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    };
    @FXML
    TableView<LogRecordModel> ctlLogTable;
    @FXML
    TableColumn<LogRecordModel, Image> ctlLogTableLevel;
    @FXML
    TableColumn<LogRecordModel, String> ctlLogTableTimestamp;
    @FXML
    TableColumn<LogRecordModel, String> ctlLogTableMessage;

    @Override
    protected void setupStage(Stage controllerStage) throws IOException {
        super.setupStage(controllerStage);
        this.ctlLogTableLevel.setCellFactory(ImageViewTableCell.forTableColumn());
        this.ctlLogTableLevel.setCellValueFactory((Callback)new PropertyValueFactory("levelImage"));
        this.ctlLogTableTimestamp.setCellValueFactory((Callback)new PropertyValueFactory("timestampString"));
        this.ctlLogTableMessage.setCellValueFactory((Callback)new PropertyValueFactory("message"));
        controllerStage.showingProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                LogViewController.this.onShowingChanged(newValue);
            }
        });
    }

    @Override
    protected StageStyle getStyle() {
        return StageStyle.UTILITY;
    }

    @Override
    protected Modality getModality() {
        return Modality.NONE;
    }

    void onShowingChanged(Boolean newValue) {
        LogBufferHandler logBuffer = LogBufferHandler.getHandler((Logger)LOG.getLogger());
        if (logBuffer != null) {
            if (Boolean.TRUE.equals(newValue)) {
                logBuffer.addHandler(this.logHandler);
            } else {
                logBuffer.removeHandler(this.logHandler);
            }
        }
    }

    void publishLogRecord(final LogRecord record) {
        if (Platform.isFxApplicationThread()) {
            if (this.getStage().isShowing()) {
                ObservableList logItems = this.ctlLogTable.getItems();
                int selectedItemIndex = this.ctlLogTable.getSelectionModel().getSelectedIndex();
                boolean updateSelection = selectedItemIndex < 0 || selectedItemIndex + 1 == logItems.size();
                logItems.add((Object)new LogRecordModel(record));
                while (logItems.size() > 1000) {
                    logItems.remove(0);
                }
                if (updateSelection) {
                    this.ctlLogTable.getSelectionModel().selectLast();
                    this.ctlLogTable.scrollTo(this.ctlLogTable.getSelectionModel().getSelectedIndex());
                }
            }
        } else {
            final CountDownLatch latch = new CountDownLatch(1);
            Platform.runLater((Runnable)new Runnable(){
                private final LogRecord recordParam;
                {
                    this.recordParam = record;
                }

                @Override
                public void run() {
                    try {
                        LogViewController.this.publishLogRecord(this.recordParam);
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

