/*
 * Decompiled with CFR 0.152.
 */
package de.carne.jfx.logview;

import de.carne.jfx.beans.TransformationReadOnlyObjectProperty;
import de.carne.jfx.logview.LogImages;
import de.carne.util.logging.Log;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.image.Image;

public class LogRecordModel {
    private static final Formatter MESSAGE_FORMATTER = new Formatter(){

        @Override
        public String format(LogRecord record) {
            return this.formatMessage(record);
        }
    };
    public static final DateTimeFormatter DEFAULT_TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss.S").withZone(ZoneId.systemDefault());
    public static final double DEFAULT_LEVEL_IMAGE_SPACE = 256.0;
    private final DateTimeFormatter timestampFormatter;
    private final double levelImageSpace;
    private final SimpleObjectProperty<Level> levelProperty = new SimpleObjectProperty();
    private TransformationReadOnlyObjectProperty<Level, String> levelNameProperty = null;
    private TransformationReadOnlyObjectProperty<Level, Image> levelImageProperty = null;
    private final SimpleObjectProperty<Instant> timestampProperty = new SimpleObjectProperty();
    private TransformationReadOnlyObjectProperty<Instant, String> timestampStringProperty = null;
    private final SimpleStringProperty messageProperty = new SimpleStringProperty();

    public LogRecordModel(LogRecord record) {
        this(record, DEFAULT_TIMESTAMP_FORMATTER, 256.0);
    }

    public LogRecordModel(LogRecord record, DateTimeFormatter timestampFormatter, double levelImageSpace) {
        assert (record != null);
        assert (timestampFormatter != null);
        this.timestampFormatter = timestampFormatter;
        this.levelImageSpace = levelImageSpace;
        this.levelProperty.set((Object)record.getLevel());
        this.timestampProperty.set((Object)Instant.ofEpochMilli(record.getMillis()));
        this.messageProperty.set(MESSAGE_FORMATTER.format(record));
    }

    public DateTimeFormatter getTimestampFormatter() {
        return this.timestampFormatter;
    }

    public double getLevelImageSpace() {
        return this.levelImageSpace;
    }

    public Level getLevel() {
        return (Level)this.levelProperty.get();
    }

    public void setLevel(Level level) {
        this.levelProperty.set((Object)level);
    }

    public ObjectProperty<Level> levelProperty() {
        return this.levelProperty;
    }

    public String getLevelString() {
        return (String)this.levelStringProperty().get();
    }

    public ReadOnlyObjectProperty<String> levelStringProperty() {
        if (this.levelNameProperty == null) {
            this.levelNameProperty = new TransformationReadOnlyObjectProperty<Level, String>((ObjectProperty<Level>)this.levelProperty, l -> Log.levelToString((Level)l));
        }
        return this.levelNameProperty;
    }

    public Image getLevelImage() {
        return (Image)this.levelImageProperty().get();
    }

    public ReadOnlyObjectProperty<Image> levelImageProperty() {
        if (this.levelImageProperty == null) {
            this.levelImageProperty = new TransformationReadOnlyObjectProperty<Level, Image>((ObjectProperty<Level>)this.levelProperty, l -> this.levelToImage((Level)l));
        }
        return this.levelImageProperty;
    }

    private Image levelToImage(Level level) {
        return LogImages.getImage(Log.snapLevel((Level)level), this.levelImageSpace);
    }

    public Instant getTimestamp() {
        return (Instant)this.timestampProperty.get();
    }

    public void setTimestamp(Instant timestamp) {
        this.timestampProperty.set((Object)timestamp);
    }

    public ObjectProperty<Instant> timestampProperty() {
        return this.timestampProperty;
    }

    public String getTimestampString() {
        return (String)this.timestampStringProperty().get();
    }

    public ReadOnlyObjectProperty<String> timestampStringProperty() {
        if (this.timestampStringProperty == null) {
            this.timestampStringProperty = new TransformationReadOnlyObjectProperty<Instant, String>((ObjectProperty<Instant>)this.timestampProperty, ts -> this.timestampToString((Instant)ts));
        }
        return this.timestampStringProperty;
    }

    private String timestampToString(Instant timestamp) {
        return this.timestampFormatter.format(timestamp);
    }

    public String getMessage() {
        return this.messageProperty.get();
    }

    public void setMessage(String message) {
        this.messageProperty.set(message);
    }

    public StringProperty messageProperty() {
        return this.messageProperty;
    }
}

