/*
 * Decompiled with CFR 0.152.
 */
package de.carne.jfx.beans;

import java.util.function.Function;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectPropertyBase;

public class TransformationReadOnlyObjectProperty<T, R>
extends ReadOnlyObjectPropertyBase<R> {
    private final ObjectProperty<T> source;
    private final Function<T, R> transformation;
    private boolean valid = true;

    public TransformationReadOnlyObjectProperty(ObjectProperty<T> source, Function<T, R> transformation) {
        assert (source != null);
        assert (transformation != null);
        this.source = source;
        this.transformation = transformation;
        this.source.addListener((InvalidationListener)new WeakInvalidationListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                TransformationReadOnlyObjectProperty.this.sourceInvalidated(observable);
            }
        }));
    }

    void sourceInvalidated(Observable observable) {
        if (this.valid) {
            this.valid = false;
            this.fireValueChangedEvent();
        }
    }

    public Object getBean() {
        return null;
    }

    public String getName() {
        return this.source.getName();
    }

    public R get() {
        this.valid = true;
        return this.transformation.apply(this.source.get());
    }
}

