/*
 * Decompiled with CFR 0.152.
 */
package de.carne.jfx.aboutinfo;

import de.carne.jfx.StageController;
import de.carne.jfx.aboutinfo.I18N;
import de.carne.util.Version;
import java.io.IOException;
import java.util.Collection;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Accordion;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TitledPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.stage.Stage;
import javafx.stage.Window;

public class AboutInfoController
extends StageController {
    private int nextInfoIndex = 0;
    @FXML
    ImageView ctlInfoIcon;
    @FXML
    Label ctlInfoString;
    @FXML
    Accordion ctlInfos;
    @FXML
    TitledPane ctlMainInfoPane;
    @FXML
    TextArea ctlMainInfoText;

    @Override
    protected boolean getResizable() {
        return false;
    }

    @Override
    protected void setupStage(Stage controllerStage) throws IOException {
        super.setupStage(controllerStage);
        controllerStage.setTitle(I18N.formatSTR_ABOUTINFO_TITLE(Version.PROJECT_ID));
        Window owner = controllerStage.getOwner();
        if (owner instanceof Stage) {
            controllerStage.getIcons().addAll((Collection)((Stage)owner).getIcons());
        }
        this.ctlInfoString.setText(I18N.formatSTR_ABOUTINFO_VERSION(Version.PROJECT_NAME, Version.PROJECT_ID, Version.BUILD_VERSION, Version.BUILD_DATE));
        this.ctlInfos.setExpandedPane(this.ctlMainInfoPane);
    }

    public void setInfoIcon(Image image) {
        this.ctlInfoIcon.setImage(image);
    }

    public void addInfo(String title, String info) {
        if (this.nextInfoIndex == 0) {
            this.ctlMainInfoPane.setText(title);
            this.ctlMainInfoText.setText(info);
        } else {
            TextArea infoText = new TextArea(info);
            TitledPane infoPane = new TitledPane(title, (Node)infoText);
            this.ctlInfos.getPanes().add((Object)infoPane);
        }
        ++this.nextInfoIndex;
    }
}

