/*
 * Decompiled with CFR 0.152.
 */
package de.carne.jfx;

import de.carne.jfx.I18N;
import de.carne.jfx.messagebox.MessageBoxController;
import de.carne.jfx.messagebox.MessageBoxResult;
import de.carne.jfx.messagebox.MessageBoxStyle;
import de.carne.util.Exceptions;
import de.carne.util.logging.Log;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.MenuBar;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public abstract class StageController {
    private static final Log LOG = new Log(StageController.class);
    private static final Pattern CONTROLLER_PATTERN = Pattern.compile("^(.*)\\.(.+)Controller$");
    private Stage stage = null;
    private ResourceBundle bundle = null;
    private static final ScheduledExecutorService EXECUTOR_SERVICE = Executors.newSingleThreadScheduledExecutor();

    void setBundle(ResourceBundle bundle) {
        assert (bundle != null);
        this.bundle = bundle;
    }

    protected ResourceBundle getBundle() {
        return this.bundle;
    }

    protected ScheduledExecutorService getExecutorService() {
        return EXECUTOR_SERVICE;
    }

    protected MenuBar getSystemMenuBar() {
        return null;
    }

    protected Preferences getPreferences() {
        return null;
    }

    protected void syncPreferences() {
        Preferences preferences = this.getPreferences();
        if (preferences != null) {
            try {
                preferences.sync();
            }
            catch (BackingStoreException e) {
                LOG.warning((Throwable)e, I18N.BUNDLE, "STR_PREF_SYNC_FAILED_MESSAGE", new Object[0]);
            }
        }
    }

    protected StageStyle getStyle() {
        return StageStyle.DECORATED;
    }

    protected Modality getModality() {
        return Modality.WINDOW_MODAL;
    }

    protected boolean getResizable() {
        return true;
    }

    protected boolean canClose() {
        return !this.stage.getScene().getRoot().isDisabled();
    }

    protected void setupStage(Stage controllerStage) throws IOException {
        this.stage = controllerStage;
        this.stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent evt) {
                StageController.this.onCloseRequest(evt);
            }
        });
    }

    private static <T extends StageController> T setupStage(Stage ownerStage, Stage controllerStage, Class<T> controllerClass) throws IOException {
        assert (controllerStage != null);
        assert (controllerClass != null);
        String controllerName = controllerClass.getName();
        Matcher controllerNameMatcher = CONTROLLER_PATTERN.matcher(controllerName);
        if (!controllerNameMatcher.find()) {
            throw new IllegalArgumentException("Invalid controller class name: " + controllerName);
        }
        String baseName = controllerNameMatcher.group(1);
        String resourceName = controllerNameMatcher.group(2);
        String fxmlResourceName = resourceName + ".fxml";
        String bundleName = baseName + ".I18N";
        LOG.debug(null, "Setting up stage for controller: {0}", new Object[]{controllerName});
        FXMLLoader loader = new FXMLLoader();
        loader.setLocation(controllerClass.getResource(fxmlResourceName));
        ResourceBundle controllerBundle = ResourceBundle.getBundle(bundleName);
        loader.setResources(controllerBundle);
        controllerStage.setScene(new Scene((Parent)loader.load()));
        StageController controller = (StageController)loader.getController();
        controllerStage.initStyle(controller.getStyle());
        if (ownerStage != null) {
            controllerStage.initOwner((Window)ownerStage);
            controllerStage.initModality(controller.getModality());
        } else {
            MenuBar systemMenuBar = controller.getSystemMenuBar();
            if (systemMenuBar != null) {
                systemMenuBar.setUseSystemMenuBar(true);
            }
        }
        controllerStage.setResizable(controller.getResizable());
        controller.setBundle(controllerBundle);
        controller.setupStage(controllerStage);
        controllerStage.sizeToScene();
        return (T)controller;
    }

    public static <T extends StageController> T setupPrimaryStage(Stage controllerStage, Class<T> controllerClass) throws IOException {
        assert (controllerStage != null);
        return StageController.setupStage(null, controllerStage, controllerClass);
    }

    public <T extends StageController> T openRootStage(Class<T> controllerClass) throws IOException {
        Stage controllerStage = new Stage();
        return StageController.setupStage(null, controllerStage, controllerClass);
    }

    public <T extends StageController> T openStage(Class<T> controllerClass) throws IOException {
        Stage controllerStage = new Stage();
        return StageController.setupStage(this.stage, controllerStage, controllerClass);
    }

    public Stage getStage() {
        return this.stage;
    }

    public MessageBoxResult showMessageBox(String message, Throwable details, MessageBoxStyle ... styles) {
        MessageBoxResult result = MessageBoxResult.NONE;
        try {
            MessageBoxController messageBoxController = this.openStage(MessageBoxController.class);
            messageBoxController.beginMessageBox(message, details, styles);
            messageBoxController.getStage().showAndWait();
            result = messageBoxController.getResult();
        }
        catch (IOException e) {
            LOG.error((Throwable)e, I18N.BUNDLE, "STR_MESSAGEBOX_EXCEPTION_MESSAGE", new Object[]{message, Exceptions.toMessage((Throwable)e)});
        }
        return result;
    }

    public void reportUnexpectedException(Throwable unexpected) {
        LOG.error(unexpected, I18N.BUNDLE, "STR_UNEXPECTED_EXCEPTION_MESSAGE", new Object[]{Exceptions.toMessage((Throwable)unexpected)});
    }

    void onCloseRequest(WindowEvent evt) {
        if (!this.canClose()) {
            evt.consume();
        }
    }
}

