/*
 * Decompiled with CFR 0.152.
 */
package de.carne.jfx;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javafx.scene.image.Image;

public final class ImageRegistry<T> {
    private final HashMap<T, List<Image>> registry = new HashMap();

    public void registerImage(T key, Image image) {
        int imageIndex;
        assert (key != null);
        assert (image != null);
        List<Image> images = this.registry.get(key);
        if (images == null) {
            images = new ArrayList<Image>();
        }
        double imageSpace = ImageRegistry.getImageSpace(image);
        int imagesSize = images.size();
        for (imageIndex = 0; imageIndex < imagesSize && imageSpace < ImageRegistry.getImageSpace(images.get(imageIndex)); ++imageIndex) {
        }
        images.add(imageIndex, image);
        this.registry.put(key, images);
    }

    public List<Image> getImages(T key) {
        assert (key != null);
        List<Image> images = this.registry.get(key);
        return images != null ? Collections.unmodifiableList(images) : Collections.emptyList();
    }

    public Image getImage(T key) {
        assert (key != null);
        List<Image> images = this.registry.get(key);
        return images != null ? images.get(0) : null;
    }

    public Image getImage(T key, double space) {
        assert (key != null);
        List<Image> images = this.registry.get(key);
        Image matchingImage = null;
        if (images != null) {
            for (Image image : images) {
                double imageSpace = ImageRegistry.getImageSpace(image);
                matchingImage = image;
                if (!(imageSpace >= space)) continue;
                break;
            }
        }
        return matchingImage;
    }

    private static double getImageSpace(Image image) {
        return image.getWidth() * image.getHeight();
    }
}

