/*
 * Copyright (c) 2007-2016 Holger de Carne and contributors, All Rights Reserved.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package de.carne.jfx.messagebox;

/**
 * Message box styles.
 */
public enum MessageBoxStyle {

	/**
	 * Show info icon.
	 */
	ICON_INFO,

	/**
	 * Show warning icon.
	 */
	ICON_WARNING,

	/**
	 * Show error icon.
	 */
	ICON_ERROR,

	/**
	 * Show question icon.
	 */
	ICON_QUESTION,

	/**
	 * Show Ok button.
	 */
	BUTTON_OK,

	/**
	 * Show Ok and Cancel button.
	 */
	BUTTON_OK_CANCEL,

	/**
	 * Show Yes and No button.
	 */
	BUTTON_YES_NO,

	/**
	 * Show Yes, No and Cancel button.
	 */
	BUTTON_YES_NO_CANCEL

}
