/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.utils;

import de.captaingoldfish.scim.sdk.common.exceptions.BadRequestException;
import de.captaingoldfish.scim.sdk.common.exceptions.InvalidFilterException;
import de.captaingoldfish.scim.sdk.common.request.BulkRequest;
import de.captaingoldfish.scim.sdk.common.resources.ServiceProvider;
import de.captaingoldfish.scim.sdk.common.schemas.Schema;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.server.filter.AttributePathRoot;
import de.captaingoldfish.scim.sdk.server.filter.FilterNode;
import de.captaingoldfish.scim.sdk.server.filter.antlr.FilterAttributeName;
import de.captaingoldfish.scim.sdk.server.filter.antlr.FilterRuleErrorListener;
import de.captaingoldfish.scim.sdk.server.filter.antlr.FilterVisitor;
import de.captaingoldfish.scim.sdk.server.filter.antlr.ScimFilterLexer;
import de.captaingoldfish.scim.sdk.server.filter.antlr.ScimFilterParser;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceType;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestUtils {
    private static final Logger log = LoggerFactory.getLogger(RequestUtils.class);

    public static List<String> getAttributes(String attributes) {
        String[] attributeNameArray = RequestUtils.getAttributeList(attributes).orElse(new String[0]);
        return Arrays.asList(attributeNameArray);
    }

    public static List<SchemaAttribute> getAttributes(ResourceType resourceType, String attributes) {
        String[] attributeNameArray = RequestUtils.getAttributeList(attributes).orElse(new String[0]);
        return Arrays.stream(attributeNameArray).map(s -> RequestUtils.getSchemaAttributeByAttributeName(resourceType, s)).collect(Collectors.toList());
    }

    private static Optional<String[]> getAttributeList(String attributes) {
        if (StringUtils.isBlank((CharSequence)attributes)) {
            return Optional.empty();
        }
        if (!attributes.matches("(^[a-zA-Z0-9]([:a-zA-Z0-9.,]+)?[a-zA-Z0-9]$)*")) {
            String errorMessage = "the attributes or excludedAttributes parameter '" + attributes + "' is malformed please check your syntax and please note that whitespaces are not allowed.";
            throw new BadRequestException(errorMessage, null, null);
        }
        return Optional.of(attributes.split(","));
    }

    public static void validateAttributesAndExcludedAttributes(String attributes, String excludedAttributes) {
        if (StringUtils.isNotBlank((CharSequence)attributes) && StringUtils.isNotBlank((CharSequence)excludedAttributes)) {
            String errorMessage = "the attributes and excludedAttributes parameter must not be set at the same time:\n\tattributes: '" + attributes + "'\n\texcludedAttributes: '" + excludedAttributes + "'";
            throw new BadRequestException(errorMessage, null, "invalidParameters");
        }
    }

    public static FilterNode parseFilter(ResourceType resourceType, String filter) {
        if (StringUtils.isBlank((CharSequence)filter)) {
            return null;
        }
        FilterRuleErrorListener filterRuleErrorListener = new FilterRuleErrorListener();
        ScimFilterLexer lexer = new ScimFilterLexer((CharStream)CharStreams.fromString((String)filter));
        lexer.removeErrorListeners();
        lexer.addErrorListener(filterRuleErrorListener);
        CommonTokenStream commonTokenStream = new CommonTokenStream((TokenSource)lexer);
        ScimFilterParser scimFilterParser = new ScimFilterParser((TokenStream)commonTokenStream);
        scimFilterParser.removeErrorListeners();
        scimFilterParser.addErrorListener(filterRuleErrorListener);
        ScimFilterParser.FilterContext filterContext = scimFilterParser.filter();
        FilterVisitor filterVisitor = new FilterVisitor(resourceType);
        return (FilterNode)filterVisitor.visit((ParseTree)filterContext);
    }

    public static AttributePathRoot parsePatchPath(ResourceType resourceType, String path) {
        if (StringUtils.isBlank((CharSequence)path)) {
            return null;
        }
        FilterRuleErrorListener filterRuleErrorListener = new FilterRuleErrorListener();
        ScimFilterLexer lexer = new ScimFilterLexer((CharStream)CharStreams.fromString((String)path));
        lexer.removeErrorListeners();
        lexer.addErrorListener(filterRuleErrorListener);
        CommonTokenStream commonTokenStream = new CommonTokenStream((TokenSource)lexer);
        ScimFilterParser scimFilterParser = new ScimFilterParser((TokenStream)commonTokenStream);
        scimFilterParser.removeErrorListeners();
        scimFilterParser.addErrorListener(filterRuleErrorListener);
        ScimFilterParser.ValuePathContext valuePathContext = scimFilterParser.valuePath();
        FilterVisitor filterVisitor = new FilterVisitor(resourceType);
        FilterNode filterNode = (FilterNode)filterVisitor.visit((ParseTree)valuePathContext);
        if (filterNode == null || !AttributePathRoot.class.isAssignableFrom(filterNode.getClass())) {
            throw new BadRequestException("the path expression is invalid and not supported for patch operations: '" + path + "'", null, "invalidPath");
        }
        AttributePathRoot attributePathRoot = (AttributePathRoot)filterNode;
        attributePathRoot.setOriginalExpressionString(path);
        return attributePathRoot;
    }

    public static long getEffectiveStartIndex(Long startIndex) {
        if (startIndex == null || startIndex < 1L) {
            return 1L;
        }
        return startIndex;
    }

    public static int getEffectiveCount(ServiceProvider serviceProvider, Integer count) {
        if (count == null) {
            return serviceProvider.getFilterConfig().getMaxResults();
        }
        if (count < 0) {
            return 0;
        }
        return Math.min(count, serviceProvider.getFilterConfig().getMaxResults());
    }

    public static SchemaAttribute getSchemaAttributeByAttributeName(ResourceType resourceType, String attributeName) {
        try {
            return StringUtils.isBlank((CharSequence)attributeName) ? null : RequestUtils.getSchemaAttribute(resourceType, new FilterAttributeName(attributeName));
        }
        catch (BadRequestException ex) {
            ex.setScimType("invalidParameters");
            throw ex;
        }
    }

    public static SchemaAttribute getSchemaAttributeForFilter(ResourceType resourceType, FilterAttributeName attributeName) {
        try {
            return RequestUtils.getSchemaAttribute(resourceType, attributeName);
        }
        catch (BadRequestException ex) {
            throw new InvalidFilterException(ex.getMessage(), (Throwable)ex);
        }
    }

    private static SchemaAttribute getSchemaAttribute(ResourceType resourceType, FilterAttributeName attributeName) {
        if (attributeName == null) {
            return null;
        }
        boolean resourceUriPresent = StringUtils.isNotBlank((CharSequence)attributeName.getResourceUri());
        String scimNodeName = attributeName.getShortName();
        List<Schema> resourceTypeSchemas = resourceType.getAllSchemas();
        List schemaAttributeList = resourceUriPresent ? resourceTypeSchemas.stream().filter(schema -> attributeName.getResourceUri().equals(schema.getId().orElse(null))).map(schema -> schema.getSchemaAttribute(scimNodeName)).filter(Objects::nonNull).collect(Collectors.toList()) : resourceTypeSchemas.stream().map(schema -> schema.getSchemaAttribute(scimNodeName)).filter(Objects::nonNull).collect(Collectors.toList());
        if (schemaAttributeList.isEmpty()) {
            throw new BadRequestException("the attribute with the name '" + attributeName.getShortName() + "' is unknown to resource type '" + resourceType.getName() + "'", null, "invalidParameters");
        }
        if (schemaAttributeList.size() > 1) {
            String schemaIds = schemaAttributeList.stream().map(schemaAttribute -> schemaAttribute.getSchema().getId().orElse(null)).collect(Collectors.joining(","));
            String exampleAttributeName = (String)((SchemaAttribute)schemaAttributeList.get(0)).getSchema().getId().orElse(null) + ":" + attributeName.getShortName();
            throw new BadRequestException("the attribute with the name '" + attributeName.getShortName() + "' is ambiguous it was found in the schemas with the ids [" + schemaIds + "]. Please use the fully qualified Uri for this attribute e.g.: " + exampleAttributeName, null, null);
        }
        return (SchemaAttribute)schemaAttributeList.get(0);
    }

    public static Map<String, String> getQueryParameters(String query) {
        String[] pairs;
        HashMap<String, String> queryParameter = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)query)) {
            return Collections.emptyMap();
        }
        for (String pair : pairs = query.split("&")) {
            String value;
            String param;
            if (StringUtils.isBlank((CharSequence)pair) || pair.charAt(0) == '=') continue;
            int index = pair.indexOf("=");
            if (index == -1) {
                param = pair;
                value = "";
            } else {
                param = pair.substring(0, index);
                value = pair.substring(index + 1);
            }
            try {
                queryParameter.put(URLDecoder.decode(param.toLowerCase(), StandardCharsets.UTF_8.name()), URLDecoder.decode(value, StandardCharsets.UTF_8.name()));
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
        return queryParameter;
    }

    public static int getEffectiveFailOnErrors(BulkRequest bulkRequest) {
        Integer failOnErrors = bulkRequest.getFailOnErrors().orElse(null);
        if (failOnErrors == null) {
            return Integer.MAX_VALUE;
        }
        if (failOnErrors < 1) {
            return 1;
        }
        return failOnErrors;
    }

    private RequestUtils() {
    }
}

