/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.response;

import de.captaingoldfish.scim.sdk.common.resources.ResourceNode;
import java.util.List;

public class PartialListResponse<T extends ResourceNode> {
    private List<T> resources;
    private long totalResults;

    PartialListResponse(List<T> resources, long totalResults) {
        this.resources = resources;
        this.totalResults = totalResults;
    }

    public static <T extends ResourceNode> PartialListResponseBuilder<T> builder() {
        return new PartialListResponseBuilder();
    }

    public List<T> getResources() {
        return this.resources;
    }

    public long getTotalResults() {
        return this.totalResults;
    }

    public static class PartialListResponseBuilder<T extends ResourceNode> {
        private List<T> resources;
        private long totalResults;

        PartialListResponseBuilder() {
        }

        public PartialListResponseBuilder<T> resources(List<T> resources) {
            this.resources = resources;
            return this;
        }

        public PartialListResponseBuilder<T> totalResults(long totalResults) {
            this.totalResults = totalResults;
            return this;
        }

        public PartialListResponse<T> build() {
            return new PartialListResponse<T>(this.resources, this.totalResults);
        }

        public String toString() {
            return "PartialListResponse.PartialListResponseBuilder(resources=" + this.resources + ", totalResults=" + this.totalResults + ")";
        }
    }
}

