/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.patch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import de.captaingoldfish.scim.sdk.common.constants.enums.PatchOp;
import de.captaingoldfish.scim.sdk.common.exceptions.BadRequestException;
import de.captaingoldfish.scim.sdk.common.request.PatchOpRequest;
import de.captaingoldfish.scim.sdk.common.request.PatchRequestOperation;
import de.captaingoldfish.scim.sdk.common.resources.ResourceNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import de.captaingoldfish.scim.sdk.common.resources.complex.Meta;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.common.utils.JsonHelper;
import de.captaingoldfish.scim.sdk.server.filter.AttributePathRoot;
import de.captaingoldfish.scim.sdk.server.patch.PatchResourceHandler;
import de.captaingoldfish.scim.sdk.server.patch.PatchTargetHandler;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceType;
import de.captaingoldfish.scim.sdk.server.utils.RequestUtils;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchHandler {
    private static final Logger log = LoggerFactory.getLogger(PatchHandler.class);
    private final ResourceType resourceType;
    private final ScimObjectNode requestedAttributes = new ScimObjectNode();
    private boolean changedResource;

    public PatchHandler(ResourceType resourceType) {
        this.resourceType = Objects.requireNonNull(resourceType);
    }

    public <T extends ResourceNode> T patchResource(T resource, PatchOpRequest patchOpRequest) {
        AtomicBoolean changeWasMade = new AtomicBoolean(false);
        for (PatchRequestOperation operation : patchOpRequest.getOperations()) {
            changeWasMade.weakCompareAndSet(false, this.handlePatchOp(resource, operation));
        }
        this.setLastModified(resource, changeWasMade);
        this.changedResource = changeWasMade.get();
        return resource;
    }

    private void setAttributeFromPath(PatchRequestOperation operation, AttributePathRoot path) {
        if (operation.getOp().equals((Object)PatchOp.REMOVE)) {
            return;
        }
        String fullName = path.getFullName() + (path.getSubAttributeName() == null ? "" : "." + path.getSubAttributeName());
        SchemaAttribute schemaAttribute = RequestUtils.getSchemaAttributeByAttributeName(this.resourceType, fullName);
        if (schemaAttribute.getParent() == null) {
            this.requestedAttributes.set(schemaAttribute.getName(), (JsonNode)new TextNode(""));
        } else {
            ScimObjectNode objectNode = new ScimObjectNode();
            objectNode.set(schemaAttribute.getName(), (JsonNode)new TextNode(""));
            this.requestedAttributes.set(schemaAttribute.getParent().getName(), (JsonNode)objectNode);
        }
    }

    private void setAttributesFromResource(PatchRequestOperation operation) {
        if (operation.getOp().equals((Object)PatchOp.REMOVE)) {
            return;
        }
        JsonNode resource = JsonHelper.readJsonDocument((String)((String)operation.getValues().get(0)));
        resource.fields().forEachRemaining(stringJsonNodeEntry -> this.requestedAttributes.set((String)stringJsonNodeEntry.getKey(), (JsonNode)stringJsonNodeEntry.getValue()));
    }

    private boolean handlePatchOp(ResourceNode resource, PatchRequestOperation operation) {
        Optional target = operation.getPath();
        List values = operation.getValues();
        if (!operation.getOp().equals((Object)PatchOp.REMOVE) && (values == null || values.isEmpty())) {
            throw new BadRequestException("no value attributes present in patch operation", null, "invalidValue");
        }
        if (target.isPresent()) {
            PatchTargetHandler patchTargetHandler = new PatchTargetHandler(this.resourceType, operation.getOp(), (String)target.get());
            boolean changeWasMade = patchTargetHandler.addOperationValues(resource, operation.getValues());
            this.setAttributeFromPath(operation, patchTargetHandler.getPath());
            return changeWasMade;
        }
        if (PatchOp.REMOVE.equals((Object)operation.getOp())) {
            throw new BadRequestException("missing target for remove operation", null, "noTarget");
        }
        if (values.size() > 1) {
            throw new BadRequestException("too many resources set in patch operation. If the target is not specified only a single value must be present in the values list which represents the resource itself", null, "invalidValue");
        }
        PatchResourceHandler patchResourceHandler = new PatchResourceHandler(this.resourceType, operation.getOp());
        boolean changeWasMade = patchResourceHandler.addResourceValues((ObjectNode)resource, JsonHelper.readJsonDocument((String)((String)values.get(0))), null);
        this.setAttributesFromResource(operation);
        return changeWasMade;
    }

    private void setLastModified(ResourceNode resource, AtomicBoolean changeWasMade) {
        if (changeWasMade.get()) {
            Optional metaOptional = resource.getMeta();
            if (metaOptional.isPresent()) {
                ((Meta)metaOptional.get()).setLastModified(LocalDateTime.now());
            } else {
                Meta meta = Meta.builder().lastModified(LocalDateTime.now()).build();
                resource.setMeta(meta);
            }
        }
    }

    public ScimObjectNode getRequestedAttributes() {
        return this.requestedAttributes;
    }

    public boolean isChangedResource() {
        return this.changedResource;
    }
}

