/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.filter.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.LongNode;
import de.captaingoldfish.scim.sdk.common.constants.enums.Comparator;
import de.captaingoldfish.scim.sdk.common.exceptions.InternalServerException;
import de.captaingoldfish.scim.sdk.common.resources.ResourceNode;
import de.captaingoldfish.scim.sdk.common.utils.TimeUtils;
import de.captaingoldfish.scim.sdk.server.filter.AndExpressionNode;
import de.captaingoldfish.scim.sdk.server.filter.AttributeExpressionLeaf;
import de.captaingoldfish.scim.sdk.server.filter.AttributePathRoot;
import de.captaingoldfish.scim.sdk.server.filter.FilterNode;
import de.captaingoldfish.scim.sdk.server.filter.NotExpressionNode;
import de.captaingoldfish.scim.sdk.server.filter.OrExpressionNode;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterResourceResolver {
    private static final Logger log = LoggerFactory.getLogger(FilterResourceResolver.class);

    public static <T extends ResourceNode> List<T> filterResources(List<T> resources, FilterNode filterNode) {
        return resources.parallelStream().filter(FilterResourceResolver.getResourcePredicate(filterNode)).collect(Collectors.toList());
    }

    private static Predicate<ResourceNode> getResourcePredicate(FilterNode filterNode) {
        return resourceNode -> FilterResourceResolver.isResourceMatchingFilter(resourceNode, filterNode);
    }

    private static boolean isResourceMatchingFilter(ResourceNode resourceNode, FilterNode filterNode) {
        if (AndExpressionNode.class.isAssignableFrom(filterNode.getClass())) {
            AndExpressionNode andExpressionNode = (AndExpressionNode)filterNode;
            return FilterResourceResolver.isResourceMatchingFilter(resourceNode, andExpressionNode.getLeftNode()) && FilterResourceResolver.isResourceMatchingFilter(resourceNode, andExpressionNode.getRightNode());
        }
        if (OrExpressionNode.class.isAssignableFrom(filterNode.getClass())) {
            OrExpressionNode orExpressionNode = (OrExpressionNode)filterNode;
            return FilterResourceResolver.isResourceMatchingFilter(resourceNode, orExpressionNode.getLeftNode()) || FilterResourceResolver.isResourceMatchingFilter(resourceNode, orExpressionNode.getRightNode());
        }
        if (NotExpressionNode.class.isAssignableFrom(filterNode.getClass())) {
            NotExpressionNode notExpressionNode = (NotExpressionNode)filterNode;
            return !FilterResourceResolver.isResourceMatchingFilter(resourceNode, notExpressionNode.getRightNode());
        }
        if (AttributeExpressionLeaf.class.isAssignableFrom(filterNode.getClass())) {
            return FilterResourceResolver.visitAttributeExpressionLeaf(resourceNode, (AttributeExpressionLeaf)filterNode);
        }
        if (AttributePathRoot.class.isAssignableFrom(filterNode.getClass())) {
            AttributePathRoot attributePathRoot = (AttributePathRoot)filterNode;
            return FilterResourceResolver.isResourceMatchingFilter(resourceNode, attributePathRoot.getChild());
        }
        return false;
    }

    private static boolean visitAttributeExpressionLeaf(ResourceNode resourceNode, AttributeExpressionLeaf attributeExpressionLeaf) {
        String[] nameParts = attributeExpressionLeaf.getShortName().split("\\.");
        if (nameParts.length == 1) {
            JsonNode simpleAttribute = FilterResourceResolver.retrieveSimpleAttributeNode((JsonNode)resourceNode, attributeExpressionLeaf);
            return FilterResourceResolver.checkValueEquality(simpleAttribute, attributeExpressionLeaf);
        }
        JsonNode complexNode = FilterResourceResolver.retrieveComplexAttributeNode((JsonNode)resourceNode, attributeExpressionLeaf);
        if (complexNode != null && complexNode.isArray()) {
            return FilterResourceResolver.evaluateMultiComplexNode(complexNode, attributeExpressionLeaf);
        }
        return FilterResourceResolver.evaluateComplexNode(complexNode, attributeExpressionLeaf);
    }

    private static JsonNode retrieveSimpleAttributeNode(JsonNode jsonNode, AttributeExpressionLeaf attributeExpressionLeaf) {
        if (attributeExpressionLeaf.isMainSchemaNode()) {
            return jsonNode.get(attributeExpressionLeaf.getSchemaAttribute().getName());
        }
        JsonNode extensionNode = jsonNode.get((String)attributeExpressionLeaf.getSchemaAttribute().getSchema().getId().get());
        return extensionNode.get(attributeExpressionLeaf.getSchemaAttribute().getName());
    }

    private static JsonNode retrieveComplexAttributeNode(JsonNode jsonNode, AttributeExpressionLeaf attributeExpressionLeaf) {
        if (attributeExpressionLeaf.isMainSchemaNode()) {
            return jsonNode.get(attributeExpressionLeaf.getSchemaAttribute().getParent().getName());
        }
        JsonNode extensionNode = jsonNode.get((String)attributeExpressionLeaf.getSchemaAttribute().getSchema().getId().get());
        return extensionNode.get(attributeExpressionLeaf.getSchemaAttribute().getParent().getName());
    }

    private static boolean evaluateMultiComplexNode(JsonNode multiComplexNode, AttributeExpressionLeaf attributeExpressionLeaf) {
        for (JsonNode complexType : multiComplexNode) {
            JsonNode simpleNode = complexType.get(attributeExpressionLeaf.getSchemaAttribute().getName());
            if (!FilterResourceResolver.checkValueEquality(simpleNode, attributeExpressionLeaf)) continue;
            return true;
        }
        return false;
    }

    private static boolean evaluateComplexNode(JsonNode complexNode, AttributeExpressionLeaf attributeExpressionLeaf) {
        if (complexNode == null) {
            return FilterResourceResolver.checkValueEquality(null, attributeExpressionLeaf);
        }
        JsonNode simpleNode = complexNode.get(attributeExpressionLeaf.getSchemaAttribute().getName());
        if (simpleNode == null) {
            return FilterResourceResolver.checkValueEquality(null, attributeExpressionLeaf);
        }
        return FilterResourceResolver.checkValueEquality(simpleNode, attributeExpressionLeaf);
    }

    protected static boolean checkValueEquality(JsonNode attributeNode, AttributeExpressionLeaf attributeExpressionLeaf) {
        switch (attributeExpressionLeaf.getType()) {
            case BOOLEAN: {
                Boolean boolValue = attributeExpressionLeaf.getBooleanValue().orElse(null);
                return FilterResourceResolver.compareBooleanValue(attributeNode, boolValue, attributeExpressionLeaf);
            }
            case INTEGER: 
            case DECIMAL: {
                return FilterResourceResolver.compareNumberValue(attributeNode, attributeExpressionLeaf.getNumberValue().orElse(null), attributeExpressionLeaf.getComparator());
            }
            case DATE_TIME: {
                return FilterResourceResolver.compareDateTimeValue(attributeNode, attributeExpressionLeaf);
            }
        }
        return FilterResourceResolver.compareStringTypeValue(attributeNode, attributeExpressionLeaf);
    }

    private static boolean compareBooleanValue(JsonNode attributeNode, Boolean boolValue, AttributeExpressionLeaf attributeExpressionLeaf) {
        Comparator comparator = attributeExpressionLeaf.getComparator();
        ArrayList<Boolean> booleanValues = new ArrayList<Boolean>();
        if (attributeNode != null && attributeNode.isArray()) {
            attributeNode.forEach(jsonNode -> booleanValues.add(jsonNode == null || jsonNode.isNull() ? null : Boolean.valueOf(jsonNode.asBoolean())));
        } else {
            booleanValues.add(attributeNode == null || attributeNode.isNull() ? null : Boolean.valueOf(attributeNode.booleanValue()));
        }
        if (booleanValues.size() == 1 && booleanValues.get(0) == null && !attributeExpressionLeaf.isMultiValued()) {
            booleanValues.clear();
            booleanValues.add(false);
        }
        for (Boolean booleanValue : booleanValues) {
            boolean anyMatch;
            switch (comparator) {
                case PR: {
                    anyMatch = booleanValue != null;
                    break;
                }
                case EQ: {
                    anyMatch = booleanValue == boolValue;
                    break;
                }
                case NE: {
                    anyMatch = booleanValue != boolValue;
                    break;
                }
                default: {
                    throw new InternalServerException("Illegal comparator '" + comparator + "' for boolean type", null, null);
                }
            }
            if (!anyMatch) continue;
            return true;
        }
        return false;
    }

    private static boolean compareStringTypeValue(JsonNode jsonNode, AttributeExpressionLeaf attributeExpressionLeaf) {
        Comparator comparator = attributeExpressionLeaf.getComparator();
        switch (comparator) {
            case PR: {
                return jsonNode != null && !jsonNode.isNull();
            }
            case EQ: {
                return FilterResourceResolver.evaluateString(jsonNode, string -> {
                    if (attributeExpressionLeaf.getSchemaAttribute().isCaseExact()) {
                        return StringUtils.equals((CharSequence)string, (CharSequence)attributeExpressionLeaf.getValue());
                    }
                    return StringUtils.equalsIgnoreCase((CharSequence)string, (CharSequence)attributeExpressionLeaf.getValue());
                });
            }
            case NE: {
                return !FilterResourceResolver.evaluateString(jsonNode, string -> {
                    if (attributeExpressionLeaf.getSchemaAttribute().isCaseExact()) {
                        return StringUtils.equals((CharSequence)string, (CharSequence)attributeExpressionLeaf.getValue());
                    }
                    return StringUtils.equalsIgnoreCase((CharSequence)string, (CharSequence)attributeExpressionLeaf.getValue());
                });
            }
            case EW: {
                return FilterResourceResolver.evaluateString(jsonNode, string -> {
                    if (attributeExpressionLeaf.getSchemaAttribute().isCaseExact()) {
                        return StringUtils.endsWith((CharSequence)string, (CharSequence)attributeExpressionLeaf.getValue());
                    }
                    return StringUtils.endsWithIgnoreCase((CharSequence)string, (CharSequence)attributeExpressionLeaf.getValue());
                });
            }
            case SW: {
                return FilterResourceResolver.evaluateString(jsonNode, string -> {
                    if (attributeExpressionLeaf.getSchemaAttribute().isCaseExact()) {
                        return StringUtils.startsWith((CharSequence)string, (CharSequence)attributeExpressionLeaf.getValue());
                    }
                    return StringUtils.startsWithIgnoreCase((CharSequence)string, (CharSequence)attributeExpressionLeaf.getValue());
                });
            }
            case CO: {
                return FilterResourceResolver.evaluateString(jsonNode, string -> {
                    if (attributeExpressionLeaf.getSchemaAttribute().isCaseExact()) {
                        return StringUtils.contains((CharSequence)string, (CharSequence)attributeExpressionLeaf.getValue());
                    }
                    return StringUtils.containsIgnoreCase((CharSequence)string, (CharSequence)attributeExpressionLeaf.getValue());
                });
            }
            case LT: {
                return FilterResourceResolver.evaluateString(jsonNode, string -> {
                    if (attributeExpressionLeaf.getSchemaAttribute().isCaseExact()) {
                        return StringUtils.compare((String)string, (String)attributeExpressionLeaf.getValue()) < 0;
                    }
                    return StringUtils.compareIgnoreCase((String)string, (String)attributeExpressionLeaf.getValue()) < 0;
                });
            }
            case LE: {
                return FilterResourceResolver.evaluateString(jsonNode, string -> {
                    if (attributeExpressionLeaf.getSchemaAttribute().isCaseExact()) {
                        return StringUtils.compare((String)string, (String)attributeExpressionLeaf.getValue()) <= 0;
                    }
                    return StringUtils.compareIgnoreCase((String)string, (String)attributeExpressionLeaf.getValue()) <= 0;
                });
            }
            case GT: {
                return FilterResourceResolver.evaluateString(jsonNode, string -> {
                    if (attributeExpressionLeaf.getSchemaAttribute().isCaseExact()) {
                        return StringUtils.compare((String)string, (String)attributeExpressionLeaf.getValue()) > 0;
                    }
                    return StringUtils.compareIgnoreCase((String)string, (String)attributeExpressionLeaf.getValue()) > 0;
                });
            }
            case GE: {
                return FilterResourceResolver.evaluateString(jsonNode, string -> {
                    if (attributeExpressionLeaf.getSchemaAttribute().isCaseExact()) {
                        return StringUtils.compare((String)string, (String)attributeExpressionLeaf.getValue()) >= 0;
                    }
                    return StringUtils.compareIgnoreCase((String)string, (String)attributeExpressionLeaf.getValue()) >= 0;
                });
            }
        }
        throw new InternalServerException("Illegal comparator '" + comparator + "' for attribute type string", null, null);
    }

    private static boolean evaluateString(JsonNode jsonNode, Function<String, Boolean> comparison) {
        ArrayList<String> stringValues = new ArrayList<String>();
        if (jsonNode != null && jsonNode.isArray()) {
            jsonNode.forEach(val -> stringValues.add(val == null || val.isNull() ? null : val.textValue()));
        } else {
            stringValues.add(jsonNode == null || jsonNode.isNull() ? null : jsonNode.textValue());
        }
        for (String stringValue : stringValues) {
            if (!comparison.apply(stringValue).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private static boolean compareDateTimeValue(JsonNode jsonNode, AttributeExpressionLeaf attributeExpressionLeaf) {
        ArrayList<String> dateTimes = new ArrayList<String>();
        if (jsonNode != null && jsonNode.isArray()) {
            jsonNode.forEach(dateNode -> dateTimes.add(dateNode.isNull() ? null : dateNode.textValue()));
        } else {
            dateTimes.add(jsonNode == null ? null : jsonNode.textValue());
        }
        if (Comparator.PR.equals((Object)attributeExpressionLeaf.getComparator())) {
            return jsonNode != null && !jsonNode.isNull();
        }
        boolean matchFound = false;
        block3: for (String dateTimeString : dateTimes) {
            if (dateTimeString == null) {
                if (!attributeExpressionLeaf.isNull()) continue;
                return true;
            }
            switch (attributeExpressionLeaf.getComparator()) {
                case EQ: 
                case NE: 
                case LT: 
                case LE: 
                case GT: 
                case GE: {
                    Instant dateTime = TimeUtils.parseDateTime((String)dateTimeString);
                    long dateTimeLong = dateTime.toEpochMilli();
                    BigDecimal compareNumber = attributeExpressionLeaf.getDateTime().map(instant -> new BigDecimal(instant.toEpochMilli())).orElse(null);
                    if (compareNumber == null) continue block3;
                    matchFound = FilterResourceResolver.compareNumberValue((JsonNode)new LongNode(dateTimeLong), compareNumber, attributeExpressionLeaf.getComparator());
                    break;
                }
                default: {
                    matchFound = FilterResourceResolver.compareStringTypeValue(jsonNode, attributeExpressionLeaf);
                }
            }
            if (!matchFound) continue;
            return true;
        }
        return matchFound;
    }

    private static boolean compareNumberValue(JsonNode number, BigDecimal compareNumber, Comparator comparator) {
        BiFunction<BigDecimal, Function, Boolean> compareDecimal = (bigDecimal, evaluateComparison) -> {
            if (bigDecimal == null) {
                return compareNumber == null;
            }
            int comparison = bigDecimal.compareTo(compareNumber);
            return (Boolean)evaluateComparison.apply(comparison);
        };
        switch (comparator) {
            case PR: {
                return number != null && !number.isNull();
            }
            case EQ: {
                return FilterResourceResolver.evaluateNumber(number, bigDecimal -> (Boolean)compareDecimal.apply((BigDecimal)bigDecimal, comparison -> comparison == 0));
            }
            case NE: {
                return !FilterResourceResolver.evaluateNumber(number, bigDecimal -> (Boolean)compareDecimal.apply((BigDecimal)bigDecimal, comparison -> comparison == 0));
            }
            case LT: {
                return FilterResourceResolver.evaluateNumber(number, bigDecimal -> (Boolean)compareDecimal.apply((BigDecimal)bigDecimal, comparison -> comparison < 0));
            }
            case LE: {
                return FilterResourceResolver.evaluateNumber(number, bigDecimal -> (Boolean)compareDecimal.apply((BigDecimal)bigDecimal, comparison -> comparison <= 0));
            }
            case GT: {
                return FilterResourceResolver.evaluateNumber(number, bigDecimal -> (Boolean)compareDecimal.apply((BigDecimal)bigDecimal, comparison -> comparison > 0));
            }
            case GE: {
                return FilterResourceResolver.evaluateNumber(number, bigDecimal -> (Boolean)compareDecimal.apply((BigDecimal)bigDecimal, comparison -> comparison >= 0));
            }
            case SW: {
                return FilterResourceResolver.getNumberStringValues(number).stream().anyMatch(s -> s.startsWith(String.valueOf(compareNumber)));
            }
            case EW: {
                return FilterResourceResolver.getNumberStringValues(number).stream().anyMatch(s -> s.endsWith(String.valueOf(compareNumber)));
            }
            case CO: {
                return FilterResourceResolver.getNumberStringValues(number).stream().anyMatch(s -> s.contains(String.valueOf(compareNumber)));
            }
        }
        throw new InternalServerException("Illegal comparator '" + comparator + "' for attribute type number or dateTime", null, null);
    }

    private static List<String> getNumberStringValues(JsonNode number) {
        ArrayList<String> numberValues = new ArrayList<String>();
        if (number.isArray()) {
            for (JsonNode jsonNode : number) {
                numberValues.add(String.valueOf(jsonNode.decimalValue().toString()));
            }
        } else {
            numberValues.add(String.valueOf(number.decimalValue().toString()));
        }
        return numberValues;
    }

    private static boolean evaluateNumber(JsonNode numberNode, Function<BigDecimal, Boolean> comparison) {
        ArrayList<BigDecimal> decimals = new ArrayList<BigDecimal>();
        if (numberNode != null && numberNode.isArray()) {
            numberNode.forEach(jsonNode -> decimals.add(jsonNode.decimalValue()));
        } else {
            decimals.add(numberNode == null ? null : numberNode.decimalValue());
        }
        for (BigDecimal decimal : decimals) {
            if (!comparison.apply(decimal).booleanValue()) continue;
            return true;
        }
        return false;
    }
}

