/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.endpoints;

import de.captaingoldfish.scim.sdk.common.constants.enums.SortOrder;
import de.captaingoldfish.scim.sdk.common.exceptions.InternalServerException;
import de.captaingoldfish.scim.sdk.common.resources.ResourceNode;
import de.captaingoldfish.scim.sdk.common.schemas.Schema;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.server.endpoints.authorize.Authorization;
import de.captaingoldfish.scim.sdk.server.filter.FilterNode;
import de.captaingoldfish.scim.sdk.server.response.PartialListResponse;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

public abstract class ResourceHandler<T extends ResourceNode> {
    private Class<T> type;
    private Schema schema;
    private List<Schema> schemaExtensions;
    private Supplier<Boolean> changePasswordSupported;
    private Supplier<Integer> maxResults;

    public ResourceHandler() {
        boolean isParametrizedType;
        Class<?> clazz = this.getClass();
        Type type = clazz.getGenericSuperclass();
        do {
            if (isParametrizedType = type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                this.type = (Class)parameterizedType.getActualTypeArguments()[0];
                continue;
            }
            clazz = clazz.getSuperclass();
            type = clazz.getGenericSuperclass();
        } while (!isParametrizedType && !ResourceHandler.class.getName().equals(clazz.getName()));
        if (this.type == null) {
            throw new InternalServerException("ResourceHandler implementations must be generified!", null, null);
        }
    }

    public abstract T createResource(T var1, Authorization var2);

    public abstract T getResource(String var1, Authorization var2, List<SchemaAttribute> var3, List<SchemaAttribute> var4);

    public abstract PartialListResponse<T> listResources(long var1, int var3, FilterNode var4, SchemaAttribute var5, SortOrder var6, List<SchemaAttribute> var7, List<SchemaAttribute> var8, Authorization var9);

    public abstract T updateResource(T var1, Authorization var2);

    public abstract void deleteResource(String var1, Authorization var2);

    public final boolean isChangePasswordSupported() {
        return Optional.ofNullable(this.changePasswordSupported).map(Supplier::get).orElse(false);
    }

    public final int getMaxResults() {
        return Optional.ofNullable(this.maxResults).map(Supplier::get).orElse(Integer.MAX_VALUE);
    }

    public Class<T> getType() {
        return this.type;
    }

    public Schema getSchema() {
        return this.schema;
    }

    protected void setSchema(Schema schema) {
        this.schema = schema;
    }

    public List<Schema> getSchemaExtensions() {
        return this.schemaExtensions;
    }

    protected void setSchemaExtensions(List<Schema> schemaExtensions) {
        this.schemaExtensions = schemaExtensions;
    }

    public Supplier<Boolean> getChangePasswordSupported() {
        return this.changePasswordSupported;
    }

    void setChangePasswordSupported(Supplier<Boolean> changePasswordSupported) {
        this.changePasswordSupported = changePasswordSupported;
    }

    void setMaxResults(Supplier<Integer> maxResults) {
        this.maxResults = maxResults;
    }
}

