/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.endpoints;

import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.common.constants.enums.HttpMethod;
import de.captaingoldfish.scim.sdk.common.constants.enums.SortOrder;
import de.captaingoldfish.scim.sdk.common.exceptions.BadRequestException;
import de.captaingoldfish.scim.sdk.common.exceptions.DocumentValidationException;
import de.captaingoldfish.scim.sdk.common.exceptions.IOException;
import de.captaingoldfish.scim.sdk.common.exceptions.InternalServerException;
import de.captaingoldfish.scim.sdk.common.exceptions.NotImplementedException;
import de.captaingoldfish.scim.sdk.common.exceptions.ResourceNotFoundException;
import de.captaingoldfish.scim.sdk.common.exceptions.ScimException;
import de.captaingoldfish.scim.sdk.common.request.PatchOpRequest;
import de.captaingoldfish.scim.sdk.common.request.SearchRequest;
import de.captaingoldfish.scim.sdk.common.resources.ResourceNode;
import de.captaingoldfish.scim.sdk.common.resources.ServiceProvider;
import de.captaingoldfish.scim.sdk.common.resources.complex.Meta;
import de.captaingoldfish.scim.sdk.common.response.CreateResponse;
import de.captaingoldfish.scim.sdk.common.response.DeleteResponse;
import de.captaingoldfish.scim.sdk.common.response.ErrorResponse;
import de.captaingoldfish.scim.sdk.common.response.GetResponse;
import de.captaingoldfish.scim.sdk.common.response.ListResponse;
import de.captaingoldfish.scim.sdk.common.response.ScimResponse;
import de.captaingoldfish.scim.sdk.common.response.UpdateResponse;
import de.captaingoldfish.scim.sdk.common.schemas.Schema;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.common.utils.JsonHelper;
import de.captaingoldfish.scim.sdk.server.endpoints.EndpointDefinition;
import de.captaingoldfish.scim.sdk.server.endpoints.ResourceHandler;
import de.captaingoldfish.scim.sdk.server.endpoints.authorize.Authorization;
import de.captaingoldfish.scim.sdk.server.endpoints.base.ResourceTypeEndpointDefinition;
import de.captaingoldfish.scim.sdk.server.endpoints.base.SchemaEndpointDefinition;
import de.captaingoldfish.scim.sdk.server.endpoints.base.ServiceProviderEndpointDefinition;
import de.captaingoldfish.scim.sdk.server.etag.ETagHandler;
import de.captaingoldfish.scim.sdk.server.filter.FilterNode;
import de.captaingoldfish.scim.sdk.server.filter.resources.FilterResourceResolver;
import de.captaingoldfish.scim.sdk.server.patch.PatchHandler;
import de.captaingoldfish.scim.sdk.server.response.PartialListResponse;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceType;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceTypeFactory;
import de.captaingoldfish.scim.sdk.server.schemas.SchemaValidator;
import de.captaingoldfish.scim.sdk.server.schemas.custom.ResourceTypeFeatures;
import de.captaingoldfish.scim.sdk.server.sort.ResourceNodeComparator;
import de.captaingoldfish.scim.sdk.server.utils.RequestUtils;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ResourceEndpointHandler {
    private static final Logger log = LoggerFactory.getLogger(ResourceEndpointHandler.class);
    private final ServiceProvider serviceProvider;
    private ResourceTypeFactory resourceTypeFactory = new ResourceTypeFactory();

    protected ResourceEndpointHandler(ServiceProvider serviceProvider, EndpointDefinition ... endpointDefinitions) {
        this.serviceProvider = serviceProvider;
        ArrayList<EndpointDefinition> endpointDefinitionList = new ArrayList<EndpointDefinition>(Arrays.asList(endpointDefinitions));
        this.registerEndpoint(new ServiceProviderEndpointDefinition(serviceProvider));
        this.registerEndpoint(new ResourceTypeEndpointDefinition(this.resourceTypeFactory));
        this.registerEndpoint(new SchemaEndpointDefinition(this.resourceTypeFactory));
        endpointDefinitionList.forEach(this::registerEndpoint);
    }

    public ResourceType registerEndpoint(EndpointDefinition endpointDefinition) {
        ResourceType resourceType = this.resourceTypeFactory.registerResourceType(endpointDefinition.getResourceHandler(), endpointDefinition.getResourceType(), endpointDefinition.getResourceSchema(), endpointDefinition.getResourceSchemaExtensions().toArray(new JsonNode[0]));
        ResourceHandler resourceHandler = resourceType.getResourceHandlerImpl();
        Schema mainSchema = resourceType.getMainSchema();
        resourceHandler.setSchema(mainSchema);
        resourceHandler.setSchemaExtensions(resourceType.getAllSchemas().stream().filter(schema -> !((String)schema.getId().get()).equals(mainSchema.getId().get())).collect(Collectors.toList()));
        resourceHandler.setChangePasswordSupported(() -> this.serviceProvider.getChangePasswordConfig().isSupported());
        resourceHandler.setMaxResults(() -> this.serviceProvider.getFilterConfig().getMaxResults());
        return resourceType;
    }

    public Optional<ResourceType> getResourceTypeByName(String name) {
        return this.resourceTypeFactory.getResourceTypeByName(name);
    }

    public Set<String> getRegisteredResourceTypeNames() {
        return this.resourceTypeFactory.getAllResourceTypes().stream().map(ResourceType::getName).collect(Collectors.toSet());
    }

    public Set<ResourceType> getRegisteredResourceTypes() {
        return new HashSet<ResourceType>(this.resourceTypeFactory.getAllResourceTypes());
    }

    public Set<Schema> getRegisteredSchemas() {
        return this.resourceTypeFactory.getSchemaFactory().getAllResourceSchemas();
    }

    protected ScimResponse createResource(String endpoint, String resourceDocument, Supplier<String> baseUrlSupplier, Authorization authorization) {
        try {
            JsonNode resource;
            if (StringUtils.isBlank((CharSequence)resourceDocument)) {
                throw new BadRequestException("the request body is empty", null, "invalidParameters");
            }
            ResourceType resourceType = this.getResourceType(endpoint);
            try {
                resource = JsonHelper.readJsonDocument((String)resourceDocument);
            }
            catch (IOException ex) {
                throw new BadRequestException(ex.getMessage(), (Throwable)ex, "unparseableRequest");
            }
            resource = SchemaValidator.validateDocumentForRequest(resourceType, resource, HttpMethod.POST);
            ResourceHandler resourceHandler = resourceType.getResourceHandlerImpl();
            ResourceNode resourceNode = (ResourceNode)JsonHelper.copyResourceToObject((JsonNode)resource, resourceHandler.getType());
            Meta meta = resourceNode.getMeta().orElse(Meta.builder().build());
            meta.setResourceType(resourceType.getName());
            resourceNode.remove("meta");
            resourceNode.setMeta(meta);
            resourceNode = resourceHandler.createResource(resourceNode, authorization);
            if (resourceNode == null) {
                throw new NotImplementedException("create was not implemented for resourceType '" + resourceType.getName() + "'");
            }
            Supplier<String> errorMessage = () -> "ID attribute not set on created resource";
            String resourceId = (String)resourceNode.getId().orElseThrow(() -> new InternalServerException((String)errorMessage.get(), null, null));
            String location = this.getLocation(resourceType, resourceId, baseUrlSupplier);
            Supplier<String> metaErrorMessage = () -> "Meta attribute not set on created resource";
            Meta createdMeta = (Meta)resourceNode.getMeta().orElseThrow(() -> new InternalServerException((String)metaErrorMessage.get(), null, null));
            if (!createdMeta.getLastModified().isPresent()) {
                createdMeta.setLastModified((Instant)createdMeta.getCreated().orElse(null));
            }
            createdMeta.setLocation(location);
            createdMeta.setResourceType(resourceType.getName());
            ETagHandler.getResourceVersion(this.serviceProvider, resourceType, resourceNode).ifPresent(arg_0 -> ((Meta)createdMeta).setVersion(arg_0));
            JsonNode responseResource = SchemaValidator.validateDocumentForResponse(this.resourceTypeFactory, resourceType, (JsonNode)resourceNode, resource, null, null, baseUrlSupplier);
            return new CreateResponse(responseResource, location, createdMeta);
        }
        catch (ScimException ex) {
            return new ErrorResponse(ex);
        }
        catch (Exception ex) {
            return new ErrorResponse((ScimException)new InternalServerException(ex.getMessage(), (Throwable)ex, null));
        }
    }

    protected ScimResponse getResource(String endpoint, String id) {
        return this.getResource(endpoint, id, null, null, Collections.emptyMap(), null, null);
    }

    protected ScimResponse getResource(String endpoint, String id, Map<String, String> httpHeaders, Supplier<String> baseUrlSupplier) {
        return this.getResource(endpoint, id, null, null, httpHeaders, baseUrlSupplier, null);
    }

    protected ScimResponse getResource(String endpoint, String id, String attributes, String excludedAttributes, Map<String, String> httpHeaders, Supplier<String> baseUrlSupplier, Authorization authorization) {
        try {
            ResourceTypeFeatures resourceTypeFeatures;
            RequestUtils.validateAttributesAndExcludedAttributes(attributes, excludedAttributes);
            ResourceType resourceType = this.getResourceType(endpoint);
            ResourceHandler resourceHandler = resourceType.getResourceHandlerImpl();
            List<SchemaAttribute> attributesList = RequestUtils.getAttributes(resourceType, attributes);
            List<SchemaAttribute> excludedAttributesList = RequestUtils.getAttributes(resourceType, excludedAttributes);
            Object resourceNode = resourceHandler.getResource(id, authorization, attributesList, excludedAttributesList);
            if (resourceNode == null) {
                throw new ResourceNotFoundException("the '" + resourceType.getName() + "' resource with id '" + id + "' does not exist", null, null);
            }
            ETagHandler.validateVersion(this.serviceProvider, resourceType, () -> resourceNode, httpHeaders);
            String resourceId = resourceNode.getId().orElse(null);
            if (resourceId != null && !resourceId.equals(id) && (resourceTypeFeatures = resourceType.getFeatures()) != null && !resourceTypeFeatures.isSingletonEndpoint()) {
                throw new InternalServerException("the id of the returned resource does not match the requested id: requestedId: '" + id + "', returnedId: '" + resourceId + "'", null, null);
            }
            String location = this.getLocation(resourceType, resourceId, baseUrlSupplier);
            resourceNode.getMeta().ifPresent(meta -> {
                if (!meta.getLastModified().isPresent()) {
                    meta.setLastModified((Instant)meta.getCreated().orElse(null));
                }
                meta.setLocation(location);
                meta.setResourceType(resourceType.getName());
                ETagHandler.getResourceVersion(this.serviceProvider, resourceType, resourceNode).ifPresent(arg_0 -> ((Meta)meta).setVersion(arg_0));
            });
            JsonNode responseResource = SchemaValidator.validateDocumentForResponse(this.resourceTypeFactory, resourceType, resourceNode, null, attributes, excludedAttributes, baseUrlSupplier);
            return new GetResponse(responseResource, location, (Meta)resourceNode.getMeta().orElse(null));
        }
        catch (ScimException ex) {
            return new ErrorResponse(ex);
        }
        catch (Exception ex) {
            return new ErrorResponse((ScimException)new InternalServerException(ex.getMessage(), (Throwable)ex, null));
        }
    }

    protected ScimResponse listResources(String endpoint, String searchRequest, Supplier<String> baseUrlSupplier, Authorization authorization) {
        return this.listResources(endpoint, StringUtils.isBlank((CharSequence)searchRequest) ? SearchRequest.builder().build() : (SearchRequest)JsonHelper.readJsonDocument((String)searchRequest, SearchRequest.class), baseUrlSupplier, authorization);
    }

    protected ScimResponse listResources(String endpoint, SearchRequest searchRequest, Supplier<String> baseUrlSupplier, Authorization authorization) {
        return this.listResources(endpoint, searchRequest.getStartIndex().orElse(null), searchRequest.getCount().orElse(null), searchRequest.getFilter().orElse(null), searchRequest.getSortBy().orElse(null), searchRequest.getSortOrder().orElse(null), searchRequest.getAttributes().orElse(null), searchRequest.getExcludedAttributes().orElse(null), baseUrlSupplier, authorization);
    }

    protected <T extends ResourceNode> ScimResponse listResources(String endpoint, Long startIndex, Integer count, String filter, String sortBy, String sortOrder, String attributes, String excludedAttributes, Supplier<String> baseUrlSupplier, Authorization authorization) {
        try {
            RequestUtils.validateAttributesAndExcludedAttributes(attributes, excludedAttributes);
            ResourceType resourceType = this.getResourceType(endpoint);
            long effectiveStartIndex = RequestUtils.getEffectiveStartIndex(startIndex);
            int effectiveCount = RequestUtils.getEffectiveCount(this.serviceProvider, count);
            FilterNode filterNode = this.getFilterNode(resourceType, filter);
            boolean autoFiltering = resourceType.getFeatures().isAutoFiltering();
            SchemaAttribute sortByAttribute = this.getSortByAttribute(resourceType, sortBy);
            SortOrder sortOrdering = this.getSortOrdering(sortOrder, sortByAttribute);
            boolean autoSorting = resourceType.getFeatures().isAutoSorting();
            List<SchemaAttribute> attributesList = RequestUtils.getAttributes(resourceType, attributes);
            List<SchemaAttribute> excludedAttributesList = RequestUtils.getAttributes(resourceType, excludedAttributes);
            ResourceHandler resourceHandler = resourceType.getResourceHandlerImpl();
            PartialListResponse resources = resourceHandler.listResources(effectiveStartIndex, effectiveCount, autoFiltering ? null : filterNode, autoSorting ? null : sortByAttribute, autoSorting ? null : sortOrdering, attributesList, excludedAttributesList, authorization);
            if (resources == null) {
                throw new NotImplementedException("listResources was not implemented for resourceType '" + resourceType.getName() + "'");
            }
            List resourceList = resources.getResources();
            List filteredResources = this.filterResources(filterNode, resourceList, resourceType);
            filteredResources = this.sortResources(filteredResources, sortByAttribute, sortOrdering, resourceType);
            long totalResults = resourceList.size() != filteredResources.size() ? (long)filteredResources.size() : (resources.getTotalResults() == 0L ? (long)filteredResources.size() : resources.getTotalResults());
            if ((filteredResources = effectiveStartIndex <= (long)filteredResources.size() ? filteredResources.subList((int)Math.min(effectiveStartIndex - 1L, (long)(filteredResources.size() - 1)), (int)Math.min(effectiveStartIndex - 1L + (long)effectiveCount, (long)filteredResources.size())) : Collections.emptyList()).size() > effectiveCount) {
                log.warn("the service provider tried to return more results than allowed. Tried to return '" + filteredResources.size() + "' results. The list will be reduced to '" + effectiveCount + "' results");
                filteredResources = filteredResources.subList(0, effectiveCount);
            }
            ArrayList<JsonNode> validatedResourceList = new ArrayList<JsonNode>();
            for (ResourceNode resourceNode : filteredResources) {
                String location = this.getLocation(resourceType, resourceNode.getId().orElse(null), baseUrlSupplier);
                resourceNode.getMeta().ifPresent(meta -> {
                    if (!meta.getLastModified().isPresent()) {
                        meta.setLastModified((Instant)meta.getCreated().orElse(null));
                    }
                    meta.setLocation(location);
                    meta.setResourceType(resourceType.getName());
                    ETagHandler.getResourceVersion(this.serviceProvider, resourceType, resourceNode).ifPresent(arg_0 -> ((Meta)meta).setVersion(arg_0));
                });
                JsonNode validatedResource = SchemaValidator.validateDocumentForResponse(this.resourceTypeFactory, resourceType, (JsonNode)resourceNode, null, attributes, excludedAttributes, baseUrlSupplier);
                validatedResourceList.add(validatedResource);
            }
            return new ListResponse(validatedResourceList, Long.valueOf(totalResults), Integer.valueOf(validatedResourceList.size()), Long.valueOf(effectiveStartIndex));
        }
        catch (ScimException ex) {
            return new ErrorResponse(ex);
        }
        catch (Exception ex) {
            return new ErrorResponse((ScimException)new InternalServerException(ex.getMessage(), (Throwable)ex, null));
        }
    }

    private <T extends ResourceNode> List<T> sortResources(List<T> filteredResources, SchemaAttribute sortByAttribute, SortOrder sortOrdering, ResourceType resourceType) {
        if (!this.serviceProvider.getSortConfig().isSupported() || sortByAttribute == null || !resourceType.getFeatures().isAutoSorting()) {
            log.trace("auto-sorting skipped for auto-sorting is not supported or missing sortBy attribute");
            return filteredResources;
        }
        return filteredResources.parallelStream().sorted(new ResourceNodeComparator(sortByAttribute, sortOrdering)).collect(Collectors.toList());
    }

    protected <T extends ResourceNode> List<T> filterResources(FilterNode filterNode, List<T> resourceList, ResourceType resourceType) {
        boolean isApplicationFilteringEnabled = resourceType.getFeatures().isAutoFiltering();
        List<T> filteredResourceType = isApplicationFilteringEnabled && filterNode != null ? FilterResourceResolver.filterResources(resourceList, filterNode) : resourceList;
        return filteredResourceType;
    }

    private FilterNode getFilterNode(ResourceType resourceType, String filter) {
        if (StringUtils.isBlank((CharSequence)filter)) {
            return null;
        }
        if (this.serviceProvider.getFilterConfig().isSupported()) {
            return RequestUtils.parseFilter(resourceType, filter);
        }
        log.debug("filter expression '{}' is not evaluated because filter support is disabled", (Object)filter);
        return null;
    }

    private SchemaAttribute getSortByAttribute(ResourceType resourceType, String sortBy) {
        if (StringUtils.isBlank((CharSequence)sortBy)) {
            return null;
        }
        if (this.serviceProvider.getSortConfig().isSupported()) {
            return RequestUtils.getSchemaAttributeByAttributeName(resourceType, sortBy);
        }
        log.debug("sortBy value '{}' is ignored because sorting support is disabled", (Object)sortBy);
        return null;
    }

    private SortOrder getSortOrdering(String sortOrder, SchemaAttribute sortBy) {
        if (StringUtils.isBlank((CharSequence)sortOrder) && sortBy != null) {
            return SortOrder.ASCENDING;
        }
        if (this.serviceProvider.getSortConfig().isSupported()) {
            return SortOrder.getByValue((String)sortOrder);
        }
        log.debug("sortOrder value '{}' is ignored because sorting support is disabled", (Object)sortOrder);
        return null;
    }

    protected ScimResponse updateResource(String endpoint, String id, String resourceDocument, Map<String, String> httpHeaders, Supplier<String> baseUrlSupplier, Authorization authorization) {
        try {
            JsonNode resource;
            if (StringUtils.isBlank((CharSequence)resourceDocument)) {
                throw new BadRequestException("the request body is empty", null, "invalidParameters");
            }
            ResourceType resourceType = this.getResourceType(endpoint);
            try {
                resource = JsonHelper.readJsonDocument((String)resourceDocument);
            }
            catch (IOException ex) {
                throw new BadRequestException(ex.getMessage(), (Throwable)ex, "unparseableRequest");
            }
            resource = SchemaValidator.validateDocumentForRequest(resourceType, resource, HttpMethod.PUT);
            ResourceHandler resourceHandler = resourceType.getResourceHandlerImpl();
            try {
                ETagHandler.validateVersion(this.serviceProvider, resourceType, () -> resourceHandler.getResource(id, authorization, null, null), httpHeaders);
            }
            catch (ResourceNotFoundException ex) {
                throw new ResourceNotFoundException("the '" + resourceType.getName() + "' resource with id '" + id + "' does not exist", (Throwable)ex, null);
            }
            if (resource == null) {
                throw new BadRequestException("the request body does not contain any writable parameters", null, "unparseableRequest");
            }
            ResourceNode resourceNode = (ResourceNode)JsonHelper.copyResourceToObject((JsonNode)resource, resourceHandler.getType());
            if (resourceNode == null) {
                throw new ResourceNotFoundException("the '" + resourceType.getName() + "' resource with id '" + id + "' does not exist", null, null);
            }
            resourceNode.setId(id);
            String location = this.getLocation(resourceType, id, baseUrlSupplier);
            Meta meta = resourceNode.getMeta().orElse(Meta.builder().build());
            resourceNode.remove("meta");
            meta.setLocation(location);
            meta.setResourceType(resourceType.getName());
            resourceNode.setMeta(meta);
            resourceNode = resourceHandler.updateResource(resourceNode, authorization);
            if (resourceNode == null) {
                throw new ResourceNotFoundException("the '" + resourceType.getName() + "' resource with id '" + id + "' does not exist", null, null);
            }
            Supplier<String> metaErrorMessage = () -> "Meta attribute not set on created resource";
            Meta createdMeta = (Meta)resourceNode.getMeta().orElseThrow(() -> new InternalServerException((String)metaErrorMessage.get(), null, null));
            if (!createdMeta.getLastModified().isPresent()) {
                createdMeta.setLastModified((Instant)createdMeta.getCreated().orElse(null));
            }
            createdMeta.setLocation(location);
            createdMeta.setResourceType(resourceType.getName());
            ETagHandler.getResourceVersion(this.serviceProvider, resourceType, resourceNode).ifPresent(arg_0 -> ((Meta)createdMeta).setVersion(arg_0));
            Supplier<String> errorMessage = () -> "ID attribute not set on updated resource";
            String resourceId = (String)resourceNode.getId().orElseThrow(() -> new InternalServerException((String)errorMessage.get(), null, null));
            if (!resourceId.equals(id)) {
                throw new InternalServerException("the id of the returned resource does not match the requested id: requestedId: '" + id + "', returnedId: '" + resourceId + "'", null, null);
            }
            JsonNode responseResource = SchemaValidator.validateDocumentForResponse(this.resourceTypeFactory, resourceType, (JsonNode)resourceNode, resource, null, null, baseUrlSupplier);
            return new UpdateResponse(responseResource, location, meta);
        }
        catch (ScimException ex) {
            return new ErrorResponse(ex);
        }
        catch (Exception ex) {
            return new ErrorResponse((ScimException)new InternalServerException(ex.getMessage(), (Throwable)ex, null));
        }
    }

    protected ScimResponse deleteResource(String endpoint, String id, Map<String, String> httpHeaders, Authorization authorization) {
        try {
            ResourceType resourceType = this.getResourceType(endpoint);
            ResourceHandler resourceHandler = resourceType.getResourceHandlerImpl();
            try {
                ETagHandler.validateVersion(this.serviceProvider, resourceType, () -> resourceHandler.getResource(id, authorization, null, null), httpHeaders);
            }
            catch (ResourceNotFoundException ex) {
                throw new ResourceNotFoundException("the '" + resourceType.getName() + "' resource with id '" + id + "' does not exist", (Throwable)ex, null);
            }
            resourceHandler.deleteResource(id, authorization);
            return new DeleteResponse();
        }
        catch (ScimException ex) {
            return new ErrorResponse(ex);
        }
        catch (Exception ex) {
            return new ErrorResponse((ScimException)new InternalServerException(ex.getMessage(), (Throwable)ex, null));
        }
    }

    protected ScimResponse patchResource(String endpoint, String id, String requestBody, Map<String, String> httpHeaders, Supplier<String> baseUrlSupplier) {
        return this.patchResource(endpoint, id, requestBody, null, null, httpHeaders, baseUrlSupplier, null);
    }

    protected ScimResponse patchResource(String endpoint, String id, String requestBody, String attributes, String excludedAttributes, Map<String, String> httpHeaders, Supplier<String> baseUrlSupplier, Authorization authorization) {
        try {
            if (!this.serviceProvider.getPatchConfig().isSupported()) {
                throw new NotImplementedException("patch is not supported by this service provider");
            }
            ResourceType resourceType = this.getResourceType(endpoint);
            ResourceHandler resourceHandler = resourceType.getResourceHandlerImpl();
            Schema patchSchema = this.resourceTypeFactory.getSchemaFactory().getMetaSchema("urn:ietf:params:scim:api:messages:2.0:PatchOp");
            JsonNode patchDocument = JsonHelper.readJsonDocument((String)requestBody);
            patchDocument = SchemaValidator.validateSchemaDocumentForRequest(patchSchema, patchDocument);
            Object resourceNode = resourceHandler.getResource(id, authorization, Collections.emptyList(), Collections.emptyList());
            if (resourceNode == null) {
                throw new ResourceNotFoundException("the '" + resourceType.getName() + "' resource with id '" + id + "' does not exist", null, null);
            }
            ETagHandler.validateVersion(this.serviceProvider, resourceType, () -> resourceNode, httpHeaders);
            Supplier<String> errorMessage = () -> "ID attribute not set on updated resource";
            String resourceId = (String)resourceNode.getId().orElseThrow(() -> new InternalServerException((String)errorMessage.get(), null, null));
            if (!resourceId.equals(id)) {
                throw new InternalServerException("the id of the returned resource does not match the requested id: requestedId: '" + id + "', returnedId: '" + resourceId + "'", null, null);
            }
            Meta meta = resourceNode.getMeta().orElse(Meta.builder().build());
            resourceNode.remove("meta");
            String location = this.getLocation(resourceType, id, baseUrlSupplier);
            meta.setLocation(location);
            meta.setResourceType(resourceType.getName());
            resourceNode.setMeta(meta);
            ETagHandler.getResourceVersion(this.serviceProvider, resourceType, resourceNode).ifPresent(arg_0 -> ((Meta)meta).setVersion(arg_0));
            PatchOpRequest patchOpRequest = (PatchOpRequest)JsonHelper.copyResourceToObject((JsonNode)patchDocument, PatchOpRequest.class);
            PatchHandler patchHandler = new PatchHandler(resourceType);
            Object patchedResourceNode = patchHandler.patchResource(resourceNode, patchOpRequest);
            try {
                SchemaValidator.validateDocumentForRequest(resourceType, patchedResourceNode, HttpMethod.PATCH);
            }
            catch (DocumentValidationException ex) {
                throw new DocumentValidationException("your patch operation created a malformed resource. The original message is: \n\t" + ex.getDetail() + "\nthe patched resource has the following structure: \n\t" + patchedResourceNode.toPrettyString(), (Throwable)ex, Integer.valueOf(400), null);
            }
            if (patchHandler.isChangedResource()) {
                patchedResourceNode.setId(id);
                patchedResourceNode = resourceHandler.updateResource(patchedResourceNode, authorization);
                meta = (Meta)patchedResourceNode.getMeta().orElseThrow(() -> new InternalServerException("The mandatory meta attribute is missing in the updated user"));
                if (!meta.getLastModified().isPresent()) {
                    meta.setLastModified((Instant)meta.getCreated().orElse(null));
                }
                meta.setResourceType(resourceType.getName());
                meta.setLocation(location);
            }
            JsonNode responseResource = SchemaValidator.validateDocumentForResponse(this.resourceTypeFactory, resourceType, patchedResourceNode, (JsonNode)patchHandler.getRequestedAttributes(), attributes, excludedAttributes, baseUrlSupplier);
            return new UpdateResponse(responseResource, location, meta);
        }
        catch (ScimException ex) {
            return new ErrorResponse(ex);
        }
        catch (Exception ex) {
            return new ErrorResponse((ScimException)new InternalServerException(ex.getMessage(), (Throwable)ex, null));
        }
    }

    private ResourceType getResourceType(String endpoint) {
        Supplier<String> errorMessage = () -> "no resource found for endpoint '" + endpoint + "'";
        ResourceType resourceType = Optional.ofNullable(this.resourceTypeFactory.getResourceType(endpoint)).orElseThrow(() -> new BadRequestException((String)errorMessage.get(), null, "unknownResource"));
        return resourceType;
    }

    private String getLocation(ResourceType resourceType, String resourceId, Supplier<String> getBaseUrlSupplier) {
        String baseUrl;
        String string = baseUrl = getBaseUrlSupplier == null ? null : getBaseUrlSupplier.get();
        if (StringUtils.isBlank((CharSequence)baseUrl)) {
            return StringUtils.stripToEmpty((String)System.getProperty("SCIM_BASE_URL")) + resourceType.getEndpoint() + (StringUtils.isBlank((CharSequence)resourceId) ? "" : "/" + resourceId);
        }
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        return baseUrl + resourceType.getEndpoint() + (StringUtils.isBlank((CharSequence)resourceId) ? "" : "/" + resourceId);
    }

    public ServiceProvider getServiceProvider() {
        return this.serviceProvider;
    }

    protected ResourceTypeFactory getResourceTypeFactory() {
        return this.resourceTypeFactory;
    }
}

