/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.schemas;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.captaingoldfish.scim.sdk.common.constants.enums.HttpMethod;
import de.captaingoldfish.scim.sdk.common.constants.enums.Mutability;
import de.captaingoldfish.scim.sdk.common.constants.enums.ReferenceTypes;
import de.captaingoldfish.scim.sdk.common.constants.enums.Returned;
import de.captaingoldfish.scim.sdk.common.constants.enums.Type;
import de.captaingoldfish.scim.sdk.common.constants.enums.Uniqueness;
import de.captaingoldfish.scim.sdk.common.exceptions.BadRequestException;
import de.captaingoldfish.scim.sdk.common.exceptions.DocumentValidationException;
import de.captaingoldfish.scim.sdk.common.exceptions.InternalServerException;
import de.captaingoldfish.scim.sdk.common.exceptions.InvalidDateTimeRepresentationException;
import de.captaingoldfish.scim.sdk.common.exceptions.ScimException;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimArrayNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimBooleanNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimDoubleNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimIntNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimLongNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimTextNode;
import de.captaingoldfish.scim.sdk.common.schemas.Schema;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.common.utils.AttributeValidator;
import de.captaingoldfish.scim.sdk.common.utils.JsonHelper;
import de.captaingoldfish.scim.sdk.common.utils.TimeUtils;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceType;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceTypeFactory;
import de.captaingoldfish.scim.sdk.server.utils.RequestUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaValidator {
    private static final Logger log = LoggerFactory.getLogger(SchemaValidator.class);
    private final boolean extensionSchema;
    private final DirectionType directionType;
    private final HttpMethod httpMethod;
    private final JsonNode validatedRequest;
    private final List<String> attributes;
    private final List<String> excludedAttributes;
    private final Supplier<String> baseUrlSupplier;
    private final ResourceTypeFactory resourceTypeFactory;

    private SchemaValidator(DirectionType directionType, String attributes, String excludedAttributes) {
        this.extensionSchema = false;
        this.directionType = directionType;
        this.httpMethod = null;
        this.validatedRequest = null;
        this.attributes = RequestUtils.getAttributes(attributes);
        this.excludedAttributes = RequestUtils.getAttributes(excludedAttributes);
        this.baseUrlSupplier = null;
        this.resourceTypeFactory = null;
    }

    private SchemaValidator(DirectionType directionType, HttpMethod httpMethod, JsonNode validatedRequest, String attributes, String excludedAttributes, Supplier<String> baseUrlSupplier, ResourceTypeFactory resourceTypeFactory) {
        this.directionType = directionType;
        this.httpMethod = httpMethod;
        this.extensionSchema = false;
        this.validatedRequest = validatedRequest;
        this.attributes = RequestUtils.getAttributes(attributes);
        this.excludedAttributes = RequestUtils.getAttributes(excludedAttributes);
        this.baseUrlSupplier = baseUrlSupplier;
        this.resourceTypeFactory = resourceTypeFactory;
    }

    private SchemaValidator(DirectionType directionType, HttpMethod httpMethod, boolean extensionSchema, JsonNode validatedRequest, String attributes, String excludedAttributes, Supplier<String> baseUrlSupplier, ResourceTypeFactory resourceTypeFactory) {
        this.directionType = directionType;
        this.httpMethod = httpMethod;
        this.extensionSchema = extensionSchema;
        this.validatedRequest = validatedRequest;
        this.attributes = RequestUtils.getAttributes(attributes);
        this.excludedAttributes = RequestUtils.getAttributes(excludedAttributes);
        this.baseUrlSupplier = baseUrlSupplier;
        this.resourceTypeFactory = resourceTypeFactory;
    }

    public static JsonNode validateSchemaDocument(Schema metaSchema, JsonNode schemaDocument) {
        SchemaValidator schemaValidator = new SchemaValidator(null, null, null);
        return schemaValidator.validateDocument(metaSchema, schemaDocument);
    }

    public static JsonNode validateSchemaDocumentForRequest(Schema metaSchema, JsonNode schemaDocument) {
        SchemaValidator schemaValidator = new SchemaValidator(DirectionType.REQUEST, null, null);
        return schemaValidator.validateDocument(metaSchema, schemaDocument);
    }

    public static JsonNode validateDocumentForResponse(ResourceTypeFactory resourceTypeFactory, ResourceType resourceType, JsonNode document, JsonNode validatedRequest, String attributes, String excludedAttributes, Supplier<String> baseUrlSupplier) throws DocumentValidationException {
        JsonNode validatedMeta;
        ResourceType.ResourceSchema resourceSchema = resourceType.getResourceSchema(document);
        JsonNode validatedMainDocument = SchemaValidator.validateDocumentForResponse(resourceSchema.getMetaSchema(), document, validatedRequest, attributes, excludedAttributes, baseUrlSupplier, resourceTypeFactory);
        SchemaValidator.validatedForMissingRequiredExtension(resourceType, document, DirectionType.RESPONSE);
        for (Schema schemaExtension : resourceSchema.getExtensions()) {
            Supplier<String> message = () -> "the extension '" + schemaExtension.getId() + "' is referenced in the '" + "schemas" + "' attribute but is not present within the document";
            JsonNode extension = Optional.ofNullable(document.get((String)schemaExtension.getId().orElse(null))).orElseThrow(() -> new InternalServerException((String)message.get(), null, "missingExtension"));
            JsonNode extensionNode = SchemaValidator.validateExtensionForResponse(schemaExtension, extension, validatedRequest == null ? null : validatedRequest.get(schemaExtension.getNonNullId()), attributes, excludedAttributes, baseUrlSupplier, resourceTypeFactory);
            if (extensionNode == null) {
                JsonHelper.getArrayAttribute((JsonNode)validatedMainDocument, (String)"schemas").ifPresent(arrayNode -> JsonHelper.removeSimpleAttributeFromArray((JsonNode)arrayNode, (String)schemaExtension.getNonNullId()));
                continue;
            }
            JsonHelper.addAttribute((JsonNode)validatedMainDocument, (String)schemaExtension.getNonNullId(), (JsonNode)extensionNode);
        }
        Schema metaSchema = resourceTypeFactory.getSchemaFactory().getMetaSchema("urn:ietf:params:scim:schemas:core:2.0:Meta");
        try {
            validatedMeta = SchemaValidator.validateExtensionForResponse(metaSchema, document, validatedRequest, attributes, excludedAttributes, baseUrlSupplier, resourceTypeFactory);
        }
        catch (ScimException ex) {
            log.error("meta attribute validation failed for resource type: " + resourceType.getName() + " [" + resourceType.getSchema() + "]");
            throw ex;
        }
        if (validatedMeta != null && validatedMeta.size() != 0 && validatedMainDocument != null) {
            JsonHelper.addAttribute((JsonNode)validatedMainDocument, (String)"meta", (JsonNode)validatedMeta.get("meta"));
        }
        return validatedMainDocument;
    }

    protected static JsonNode validateDocumentForResponse(Schema metaSchema, JsonNode document, Supplier<String> baseUrlSupplier, ResourceTypeFactory resourceTypeFactory) {
        return SchemaValidator.validateDocumentForResponse(metaSchema, document, null, null, null, baseUrlSupplier, resourceTypeFactory);
    }

    protected static JsonNode validateDocumentForResponse(Schema metaSchema, JsonNode document, JsonNode validatedRequest, String attributes, String excludedAttributes, Supplier<String> baseUrlSupplier, ResourceTypeFactory resourceTypeFactory) {
        SchemaValidator schemaValidator = new SchemaValidator(DirectionType.RESPONSE, null, validatedRequest, attributes, excludedAttributes, baseUrlSupplier, resourceTypeFactory);
        try {
            return schemaValidator.validateDocument(metaSchema, document);
        }
        catch (ScimException ex) {
            ex.setStatus(500);
            throw ex;
        }
    }

    private static JsonNode validateExtensionForResponse(Schema metaSchema, JsonNode document, JsonNode validatedRequest, String attributes, String excludedAttributes, Supplier<String> baseUrlSupplier, ResourceTypeFactory resourceTypeFactory) {
        SchemaValidator schemaValidator = new SchemaValidator(DirectionType.RESPONSE, null, true, validatedRequest, attributes, excludedAttributes, baseUrlSupplier, resourceTypeFactory);
        try {
            return schemaValidator.validateDocument(metaSchema, document);
        }
        catch (ScimException ex) {
            ex.setStatus(500);
            throw ex;
        }
    }

    public static JsonNode validateDocumentForRequest(ResourceType resourceType, JsonNode document, HttpMethod httpMethod) throws DocumentValidationException {
        ResourceType.ResourceSchema resourceSchema = resourceType.getResourceSchema(document);
        JsonNode validatedMainDocument = SchemaValidator.validateDocumentForRequest(resourceSchema.getMetaSchema(), document, httpMethod);
        if (validatedMainDocument == null) {
            throw new DocumentValidationException("the received document is invalid and does not contain any data. The illegal document is: " + document.toString(), null, Integer.valueOf(400), null);
        }
        SchemaValidator.validatedForMissingRequiredExtension(resourceType, document, DirectionType.REQUEST);
        for (Schema schemaExtension : resourceSchema.getExtensions()) {
            Supplier<String> message = () -> "the extension '" + schemaExtension.getId().orElse("null") + "' is referenced in the '" + "schemas" + "' attribute but is not present within the document";
            JsonNode extension = Optional.ofNullable(document.get(schemaExtension.getNonNullId())).orElseThrow(() -> new BadRequestException((String)message.get(), null, "missingExtension"));
            JsonNode extensionNode = SchemaValidator.validateExtensionForRequest(schemaExtension, extension, httpMethod);
            if (extensionNode == null) {
                JsonHelper.getArrayAttribute((JsonNode)validatedMainDocument, (String)"schemas").ifPresent(arrayNode -> JsonHelper.removeSimpleAttributeFromArray((JsonNode)arrayNode, (String)schemaExtension.getNonNullId()));
                continue;
            }
            JsonHelper.addAttribute((JsonNode)validatedMainDocument, (String)schemaExtension.getNonNullId(), (JsonNode)extensionNode);
        }
        if (document.has("meta")) {
            ((ObjectNode)validatedMainDocument).set("meta", document.get("meta"));
        }
        return validatedMainDocument;
    }

    protected static JsonNode validateDocumentForRequest(Schema metaSchema, JsonNode document, HttpMethod httpMethod) {
        SchemaValidator schemaValidator = new SchemaValidator(DirectionType.REQUEST, httpMethod, null, null, null, null, null);
        try {
            return schemaValidator.validateDocument(metaSchema, document);
        }
        catch (ScimException ex) {
            ex.setStatus(400);
            throw ex;
        }
    }

    protected static JsonNode validateExtensionForRequest(Schema metaSchema, JsonNode document, HttpMethod httpMethod) {
        SchemaValidator schemaValidator = new SchemaValidator(DirectionType.REQUEST, httpMethod, true, null, null, null, null, null);
        try {
            return schemaValidator.validateDocument(metaSchema, document);
        }
        catch (ScimException ex) {
            ex.setStatus(400);
            throw ex;
        }
    }

    private static void validatedForMissingRequiredExtension(ResourceType resourceType, JsonNode document, DirectionType directionType) {
        for (Schema requiredExtension : resourceType.getRequiredResourceSchemaExtensions()) {
            if (JsonHelper.getObjectAttribute((JsonNode)document, (String)requiredExtension.getNonNullId()).isPresent()) continue;
            String errorMessage = "required extension '" + requiredExtension.getId() + "' is missing in the document";
            throw new DocumentValidationException(errorMessage, null, Integer.valueOf(directionType == null ? 500 : directionType.getHttpStatus()), null);
        }
    }

    private JsonNode validateDocument(Schema metaSchema, JsonNode document) {
        JsonNode validatedDocument;
        log.trace("validating metaSchema vs document");
        JsonNode schemasNode = null;
        if (!this.extensionSchema) {
            schemasNode = this.checkDocumentAndMetaSchemaRelationship(metaSchema, document);
        }
        if ((validatedDocument = this.validateAttributes(metaSchema.getAttributes(), document, null)) != null && schemasNode != null) {
            JsonHelper.addAttribute((JsonNode)validatedDocument, (String)"schemas", (JsonNode)schemasNode);
        }
        return validatedDocument;
    }

    private JsonNode validateAttributes(List<SchemaAttribute> metaAttributes, JsonNode document, SchemaAttribute parentAttribute) {
        ScimObjectNode scimNode = new ScimObjectNode(parentAttribute);
        for (SchemaAttribute metaAttribute : metaAttributes) {
            if (document == null) {
                this.validateIsRequired(null, metaAttribute);
                continue;
            }
            this.checkMetaAttributeOnDocument(document, metaAttribute).ifPresent(arg_0 -> SchemaValidator.lambda$validateAttributes$6((JsonNode)scimNode, metaAttribute, arg_0));
        }
        if (scimNode.size() == 0) {
            return null;
        }
        return scimNode;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Optional<JsonNode> checkMetaAttributeOnDocument(JsonNode document, SchemaAttribute schemaAttribute) {
        JsonNode documentNode = document.get(schemaAttribute.getName());
        log.trace("validating attribute '{}' with value '{}'", (Object)schemaAttribute.getName(), (Object)Optional.ofNullable(documentNode).map(JsonNode::textValue).orElse(Optional.ofNullable(documentNode).map(JsonNode::toString).orElse(null)));
        this.validateIsRequired(documentNode, schemaAttribute);
        if (this.directionType != null && this.directionType.equals((Object)DirectionType.RESPONSE) && documentNode == null && schemaAttribute.getReferenceTypes().contains(ReferenceTypes.RESOURCE)) {
            Optional<JsonNode> overriddenReferenceNode = this.overrideEmptyReferenceNode(document, schemaAttribute);
            if (!overriddenReferenceNode.isPresent()) {
                this.validateNonPresentAttributes(schemaAttribute);
                return Optional.empty();
            }
            documentNode = overriddenReferenceNode.get();
        } else {
            if (documentNode == null) {
                this.validateNonPresentAttributes(schemaAttribute);
                return Optional.empty();
            }
            if (!this.validatePresentAttributes(schemaAttribute)) {
                return Optional.empty();
            }
        }
        this.validateComplexAndArrayTypeAttribute(documentNode, schemaAttribute);
        if (schemaAttribute.isMultiValued()) {
            return this.handleMultivaluedNodes(documentNode, schemaAttribute);
        }
        return this.handleNode(documentNode, schemaAttribute);
    }

    private Optional<JsonNode> overrideEmptyReferenceNode(JsonNode document, SchemaAttribute schemaAttribute) {
        SchemaAttribute parentAttribute = schemaAttribute.getParent();
        Optional<SchemaAttribute> valueAttribute = parentAttribute.getSubAttributes().stream().filter(attribute -> attribute.getName().equals("value")).findAny();
        Optional<SchemaAttribute> typeAttribute = parentAttribute.getSubAttributes().stream().filter(attribute -> attribute.getName().equals("type")).findAny();
        if (!valueAttribute.isPresent() || !typeAttribute.isPresent()) {
            return Optional.empty();
        }
        String referenceId = Optional.ofNullable(document.get(valueAttribute.get().getName())).map(JsonNode::textValue).orElse(null);
        String typeReference = Optional.ofNullable(document.get(typeAttribute.get().getName())).map(JsonNode::textValue).orElse(null);
        ResourceType referencedResourceType = this.resourceTypeFactory.getResourceTypeByName(typeReference).orElse(null);
        if (referenceId == null || typeReference == null || referencedResourceType == null) {
            return Optional.empty();
        }
        ObjectNode objectNode = (ObjectNode)document;
        ScimTextNode newReferencenode = new ScimTextNode(schemaAttribute, this.baseUrlSupplier.get() + referencedResourceType.getEndpoint() + "/" + referenceId);
        objectNode.set(schemaAttribute.getName(), (JsonNode)newReferencenode);
        return Optional.of(newReferencenode);
    }

    private void validateComplexAndArrayTypeAttribute(JsonNode document, SchemaAttribute schemaAttribute) {
        Supplier<String> errorMessage = () -> String.format("the attribute '%s' does not apply to its defined type. The received document node is of type '%s' but the schema defintion is as follows: \n\tmultivalued: %s\n\ttype: %s\nfor schema with id %s\n%s", schemaAttribute.getScimNodeName(), document.getNodeType(), schemaAttribute.isMultiValued(), schemaAttribute.getType(), schemaAttribute.getSchema().getId().orElse(null), document.toString());
        if (schemaAttribute.isMultiValued() ? document != null && !document.isArray() || document != null && Type.COMPLEX.equals((Object)schemaAttribute.getType()) && document.size() != 0 && !document.get(0).isObject() : Type.COMPLEX.equals((Object)schemaAttribute.getType()) && document != null && !document.isObject()) {
            throw new DocumentValidationException(errorMessage.get(), null, this.getHttpStatus(), null);
        }
    }

    private Optional<JsonNode> handleMultivaluedNodes(JsonNode document, SchemaAttribute schemaAttribute) {
        if (Type.COMPLEX.equals((Object)schemaAttribute.getType())) {
            AtomicInteger countPrimary = new AtomicInteger(0);
            return this.handleMultivaluedNode(document, schemaAttribute, (jsonNode, scimArrayNode) -> {
                countPrimary.set(this.checkForPrimary((JsonNode)jsonNode, schemaAttribute, countPrimary.get()));
                this.handleComplexNode((JsonNode)jsonNode, schemaAttribute).ifPresent(returnedAttribute -> JsonHelper.addAttributeToArray((JsonNode)scimArrayNode, (JsonNode)returnedAttribute));
            });
        }
        return this.handleMultivaluedNode(document, schemaAttribute, (jsonNode, scimArrayNode) -> {
            JsonNode attribute = this.handleSimpleNode((JsonNode)jsonNode, schemaAttribute);
            JsonHelper.addAttributeToArray((JsonNode)scimArrayNode, (JsonNode)attribute);
        });
    }

    private int checkForPrimary(JsonNode jsonNode, SchemaAttribute schemaAttribute, int primaryCounter) {
        boolean isPrimary = JsonHelper.getSimpleAttribute((JsonNode)jsonNode, (String)"primary", Boolean.class).orElse(false);
        int counter = primaryCounter + (isPrimary ? 1 : 0);
        if (counter > 1) {
            String errorMessage = "multiple primary values detected in attribute with name '" + schemaAttribute.getFullResourceName() + "'";
            throw this.getException(errorMessage, null);
        }
        return counter;
    }

    private Optional<JsonNode> handleMultivaluedNode(JsonNode document, SchemaAttribute schemaAttribute, BiConsumer<JsonNode, ScimArrayNode> handleMultivaluedNode) {
        ArrayNode arrayNode;
        if (document.isArray()) {
            arrayNode = (ArrayNode)document;
        } else {
            arrayNode = new ArrayNode(JsonNodeFactory.instance);
            arrayNode.add(document);
        }
        ScimArrayNode scimArrayNode = new ScimArrayNode(schemaAttribute);
        for (JsonNode jsonNode : arrayNode) {
            this.checkForUniqueAttribute(schemaAttribute, scimArrayNode, jsonNode);
            handleMultivaluedNode.accept(jsonNode, scimArrayNode);
        }
        AttributeValidator.validateArrayNode((SchemaAttribute)schemaAttribute, (ArrayNode)scimArrayNode);
        if (scimArrayNode.size() == 0) {
            this.validateNonPresentAttributes(schemaAttribute);
            return Optional.empty();
        }
        return Optional.of(scimArrayNode);
    }

    private Optional<JsonNode> handleNode(JsonNode document, SchemaAttribute schemaAttribute) {
        if (Type.COMPLEX.equals((Object)schemaAttribute.getType())) {
            return this.handleComplexNode(document, schemaAttribute);
        }
        return Optional.of(this.handleSimpleNode(document, schemaAttribute));
    }

    private Optional<JsonNode> handleComplexNode(JsonNode document, SchemaAttribute schemaAttribute) {
        this.validateIsRequired(document, schemaAttribute);
        List metaSubAttributes = schemaAttribute.getSubAttributes();
        return Optional.ofNullable(this.validateAttributes(metaSubAttributes, document, schemaAttribute));
    }

    private JsonNode handleSimpleNode(JsonNode simpleDocumentNode, SchemaAttribute schemaAttribute) {
        this.checkCanonicalValues(schemaAttribute, simpleDocumentNode);
        Type type = schemaAttribute.getType();
        switch (type) {
            case STRING: {
                this.isNodeOfExpectedType(schemaAttribute, simpleDocumentNode, jsonNode -> jsonNode.isTextual() || jsonNode.isObject());
                return new ScimTextNode(schemaAttribute, simpleDocumentNode.isTextual() ? simpleDocumentNode.textValue() : simpleDocumentNode.toString());
            }
            case BOOLEAN: {
                this.isNodeOfExpectedType(schemaAttribute, simpleDocumentNode, JsonNode::isBoolean);
                return new ScimBooleanNode(schemaAttribute, simpleDocumentNode.booleanValue());
            }
            case INTEGER: {
                this.isNodeOfExpectedType(schemaAttribute, simpleDocumentNode, jsonNode -> jsonNode.isInt() || jsonNode.isLong() || jsonNode.isBigDecimal());
                if ((long)simpleDocumentNode.intValue() == simpleDocumentNode.longValue()) {
                    return new ScimIntNode(schemaAttribute, simpleDocumentNode.intValue());
                }
                return new ScimLongNode(schemaAttribute, (long)simpleDocumentNode.intValue());
            }
            case DECIMAL: {
                this.isNodeOfExpectedType(schemaAttribute, simpleDocumentNode, jsonNode -> jsonNode.isInt() || jsonNode.isLong() || jsonNode.isFloat() || jsonNode.isDouble() || jsonNode.isBigDecimal());
                return new ScimDoubleNode(schemaAttribute, simpleDocumentNode.doubleValue());
            }
            case DATE_TIME: {
                this.isNodeOfExpectedType(schemaAttribute, simpleDocumentNode, JsonNode::isTextual);
                this.parseDateTime(simpleDocumentNode.textValue());
                return new ScimTextNode(schemaAttribute, simpleDocumentNode.textValue());
            }
        }
        this.isNodeOfExpectedType(schemaAttribute, simpleDocumentNode, JsonNode::isTextual);
        this.validateValueNodeWithReferenceTypes(schemaAttribute, simpleDocumentNode);
        return new ScimTextNode(schemaAttribute, simpleDocumentNode.textValue());
    }

    private void validateIsRequired(JsonNode document, SchemaAttribute schemaAttribute) {
        if (!schemaAttribute.isRequired()) {
            return;
        }
        if (DirectionType.REQUEST.equals((Object)this.directionType)) {
            this.validateIsRequiredForRequest(document, schemaAttribute);
        } else {
            this.validateIsRequiredForResponse(document, schemaAttribute);
        }
    }

    private void validateIsRequiredForRequest(JsonNode document, SchemaAttribute schemaAttribute) {
        boolean isNodeNull = document == null || document.isNull();
        Supplier<String> errorMessage = () -> "the attribute '" + schemaAttribute.getFullResourceName() + "' is required " + (this.httpMethod == null ? "" : "for http method '" + this.httpMethod + "' ") + "\n\tmutability: '" + schemaAttribute.getMutability() + "'\n\treturned: '" + schemaAttribute.getReturned() + "'";
        if ((Mutability.READ_WRITE.equals((Object)schemaAttribute.getMutability()) || Mutability.WRITE_ONLY.equals((Object)schemaAttribute.getMutability())) && isNodeNull) {
            throw new DocumentValidationException(errorMessage.get(), null, this.getHttpStatus(), "required");
        }
        if (Mutability.IMMUTABLE.equals((Object)schemaAttribute.getMutability()) && HttpMethod.POST.equals((Object)this.httpMethod) && isNodeNull) {
            throw new DocumentValidationException(errorMessage.get(), null, this.getHttpStatus(), "required");
        }
    }

    private void validateIsRequiredForResponse(JsonNode document, SchemaAttribute schemaAttribute) {
        boolean isNodeNull = document == null || document.isNull();
        Supplier<String> errorMessage = () -> String.format("the attribute '%s' is required on response.\n\t\tname: '%s'\n\t\ttype: '%s'\n\t\tdescription: '%s'\n\t\tmutability: '%s'\n\t\treturned: '%s'\n\t\tuniqueness: '%s'\n\t\tmultivalued: '%s'\n\t\trequired: '%s'\n\t\tcaseExact: '%s'", schemaAttribute.getFullResourceName(), schemaAttribute.getName(), schemaAttribute.getType().toString(), schemaAttribute.getDescription(), schemaAttribute.getMutability(), schemaAttribute.getReturned(), schemaAttribute.getUniqueness().toString(), schemaAttribute.isMultiValued(), schemaAttribute.isRequired(), schemaAttribute.isCaseExact());
        if (isNodeNull && !Mutability.WRITE_ONLY.equals((Object)schemaAttribute.getMutability())) {
            throw this.getException(errorMessage.get(), null);
        }
    }

    private void checkForUniqueAttribute(SchemaAttribute schemaAttribute, ScimArrayNode scimArrayNode, JsonNode jsonNode) {
        if (!Uniqueness.NONE.equals((Object)schemaAttribute.getUniqueness())) {
            for (JsonNode complexNode : scimArrayNode) {
                if (!complexNode.equals((Object)jsonNode)) continue;
                String errorMessage = "the array node with name '" + schemaAttribute.getFullResourceName() + "' has a uniqueness of '" + schemaAttribute.getUniqueness() + "' but has at least one duplicate value: '" + complexNode.toString() + "'";
                throw this.getException(errorMessage, null);
            }
        }
    }

    private void validateNonPresentAttributes(SchemaAttribute schemaAttribute) {
        if (DirectionType.RESPONSE.equals((Object)this.directionType)) {
            this.validateNonPresentAttributesForResponse(schemaAttribute);
        }
    }

    private void validateNonPresentAttributesForResponse(SchemaAttribute schemaAttribute) {
        String scimNodeName = schemaAttribute.getScimNodeName();
        if (Returned.ALWAYS.equals((Object)schemaAttribute.getReturned())) {
            log.debug("the attribute '{}' has a returned value of '{}' and is therefore a required attribute in theminimal dataset of the resource but it is missing in the response document.", (Object)scimNodeName, (Object)schemaAttribute.getReturned());
        } else if ((Returned.REQUEST.equals((Object)schemaAttribute.getReturned()) || Returned.DEFAULT.equals((Object)schemaAttribute.getReturned())) && this.attributes.stream().anyMatch(s -> StringUtils.equalsIgnoreCase((CharSequence)s, (CharSequence)scimNodeName))) {
            log.debug("the attribute '{}' was requested by the client but it is not present within the document. Maybe the value has not been set on the resource?", (Object)scimNodeName);
        }
    }

    private boolean validatePresentAttributes(SchemaAttribute schemaAttribute) {
        if (DirectionType.RESPONSE.equals((Object)this.directionType)) {
            return this.validatePresentAttributesForResponse(schemaAttribute);
        }
        if (DirectionType.REQUEST.equals((Object)this.directionType)) {
            return this.validatePresentAttributesForRequest(schemaAttribute);
        }
        return true;
    }

    private boolean validatePresentAttributesForRequest(SchemaAttribute schemaAttribute) {
        if (Mutability.READ_ONLY.equals((Object)schemaAttribute.getMutability())) {
            log.debug("removed attribute '{}' from request since it has a mutability of {}", (Object)schemaAttribute.getFullResourceName(), (Object)schemaAttribute.getMutability());
            return false;
        }
        return true;
    }

    private boolean validatePresentAttributesForResponse(SchemaAttribute schemaAttribute) {
        if (Returned.ALWAYS.equals((Object)schemaAttribute.getReturned())) {
            return true;
        }
        if (!this.excludedAttributes.isEmpty() && this.isExcludedParameterPresent(schemaAttribute)) {
            return false;
        }
        if (Returned.NEVER.equals((Object)schemaAttribute.getReturned())) {
            log.warn("attribute '{}' was present on the response document but has a returned value of '{}'. Attribute is being removed from response document", (Object)schemaAttribute.getFullResourceName(), (Object)schemaAttribute.getReturned());
            return false;
        }
        if (Returned.DEFAULT.equals((Object)schemaAttribute.getReturned()) && !this.attributes.isEmpty() && this.isAttributeMissingInAttributeParameter(schemaAttribute) && !this.isAttributePresentInRequest(schemaAttribute)) {
            log.trace("removing attribute '{}' from response for its returned value is '{}' and its name is not in the list of requested attributes: {}", new Object[]{schemaAttribute.getFullResourceName(), schemaAttribute.getReturned(), this.attributes});
            return false;
        }
        if (Returned.REQUEST.equals((Object)schemaAttribute.getReturned()) && this.isAttributeMissingInAttributeParameter(schemaAttribute) && !this.isAttributePresentInRequest(schemaAttribute)) {
            log.trace("removing attribute '{}' from response for its returned value is '{}' and its name is not in the list of requested attributes: {}", new Object[]{schemaAttribute.getFullResourceName(), schemaAttribute.getReturned(), this.attributes});
            return false;
        }
        return true;
    }

    private boolean isExcludedParameterPresent(SchemaAttribute schemaAttribute) {
        String shortName = schemaAttribute.getScimNodeName();
        String fullName = schemaAttribute.getResourceUri() + ":" + shortName;
        boolean anyFullNameMatch = this.excludedAttributes.stream().anyMatch(param -> StringUtils.equalsIgnoreCase((CharSequence)fullName, (CharSequence)param) || StringUtils.equalsIgnoreCase((CharSequence)shortName, (CharSequence)param) || StringUtils.equalsIgnoreCase((CharSequence)param, (CharSequence)schemaAttribute.getResourceUri()));
        return anyFullNameMatch;
    }

    private boolean isAttributeMissingInAttributeParameter(SchemaAttribute schemaAttribute) {
        String shortName = schemaAttribute.getScimNodeName();
        String fullName = schemaAttribute.getResourceUri() + ":" + shortName;
        boolean anyNameMatch = this.attributes.stream().anyMatch(param -> StringUtils.equalsIgnoreCase((CharSequence)fullName, (CharSequence)param) || StringUtils.equalsIgnoreCase((CharSequence)shortName, (CharSequence)param) || StringUtils.startsWithIgnoreCase((CharSequence)fullName, (CharSequence)param) && StringUtils.endsWithIgnoreCase((CharSequence)fullName, (CharSequence)("." + schemaAttribute.getName())) || StringUtils.startsWithIgnoreCase((CharSequence)shortName, (CharSequence)(param + ".")) || StringUtils.startsWith((CharSequence)param, (CharSequence)(fullName + ".")) || StringUtils.startsWithIgnoreCase((CharSequence)param, (CharSequence)(shortName + ".")) || StringUtils.equalsIgnoreCase((CharSequence)param, (CharSequence)schemaAttribute.getResourceUri()));
        return !anyNameMatch;
    }

    private boolean isAttributePresentInRequest(SchemaAttribute schemaAttribute) {
        String[] scimNodeParts = schemaAttribute.getScimNodeName().split("\\.");
        if (this.validatedRequest == null) {
            return false;
        }
        JsonNode jsonNode = this.validatedRequest.get(scimNodeParts[0]);
        if (jsonNode == null) {
            return false;
        }
        if (scimNodeParts.length == 1) {
            return true;
        }
        ScimNode subNode = (ScimNode)jsonNode.get(scimNodeParts[1]);
        if (subNode == null) {
            return false;
        }
        return !subNode.isMultiValued();
    }

    private void checkCanonicalValues(SchemaAttribute attributeDefinition, JsonNode valueNode) {
        if (attributeDefinition.getCanonicalValues().isEmpty()) {
            return;
        }
        String value = valueNode.textValue();
        if (attributeDefinition.getCanonicalValues().stream().noneMatch(s -> StringUtils.equalsIgnoreCase((CharSequence)s, (CharSequence)value))) {
            String errorMessage = "attribute with name '" + attributeDefinition.getName() + "' does not have one of the canonicalValues: '" + attributeDefinition.getCanonicalValues() + "' actual value is: '" + value + "'";
            throw this.getException(errorMessage, null);
        }
    }

    private void isNodeOfExpectedType(SchemaAttribute attributeDefinition, JsonNode valueNode, Function<JsonNode, Boolean> isOfType) {
        Type type = attributeDefinition.getType();
        String errorMessage = "value of field with name '" + attributeDefinition.getFullResourceName() + "' is not of type '" + type.getValue() + "' but of type: " + StringUtils.lowerCase((String)valueNode.getNodeType().toString());
        this.checkAttributeValidity(isOfType.apply(valueNode), errorMessage);
    }

    private void checkAttributeValidity(Boolean aBoolean, String errorMessage) {
        if (!aBoolean.booleanValue()) {
            throw this.getException(errorMessage, null);
        }
    }

    private void parseDateTime(String textValue) {
        try {
            TimeUtils.parseDateTime((String)textValue);
        }
        catch (InvalidDateTimeRepresentationException ex) {
            throw new DocumentValidationException("given value is not a valid dateTime: " + textValue, null, this.getHttpStatus(), null);
        }
    }

    private void validateValueNodeWithReferenceTypes(SchemaAttribute attributeDefinition, JsonNode valueNode) {
        boolean isValidReferenceType = false;
        for (ReferenceTypes referenceType : attributeDefinition.getReferenceTypes()) {
            switch (referenceType) {
                case RESOURCE: 
                case URI: {
                    isValidReferenceType = this.parseUri(valueNode.textValue());
                    break;
                }
                default: {
                    isValidReferenceType = true;
                }
            }
            if (!isValidReferenceType) continue;
            break;
        }
        this.checkAttributeValidity(isValidReferenceType, "given value is not a valid reference type: " + valueNode.textValue() + ": was expected to be of one of the following types: " + attributeDefinition.getReferenceTypes());
    }

    private boolean parseUri(String textValue) {
        try {
            new URI(textValue);
            return true;
        }
        catch (URISyntaxException ex) {
            log.debug(ex.getMessage());
            return false;
        }
    }

    private JsonNode checkDocumentAndMetaSchemaRelationship(Schema metaSchema, JsonNode document) {
        String metaSchemaId = metaSchema.getNonNullId();
        String schemasAttribute = "schemas";
        String documentNoSchemasMessage = "document does not have a 'schemas'-attribute";
        List documentSchemas = (List)JsonHelper.getSimpleAttributeArray((JsonNode)document, (String)"schemas").orElseThrow(() -> this.getException("document does not have a 'schemas'-attribute", null));
        if (!documentSchemas.contains(metaSchemaId)) {
            String errorMessage = "document can not be validated against meta-schema with id '" + metaSchemaId + "' for id is missing in the '" + "schemas" + "'-list. The given document can only be validated against the following schemas: " + documentSchemas;
            throw this.getException(errorMessage, null);
        }
        log.trace("meta schema with id {} does apply to document with schemas '{}'", (Object)metaSchemaId, (Object)documentSchemas);
        ScimArrayNode schemasNode = new ScimArrayNode(null);
        schemasNode.addAll((Collection)documentSchemas.stream().map(s -> new ScimTextNode(null, s)).collect(Collectors.toList()));
        return schemasNode;
    }

    private DocumentValidationException getException(String errorMessage, Exception cause) {
        return new DocumentValidationException(errorMessage, (Throwable)cause, this.getHttpStatus(), null);
    }

    private Integer getHttpStatus() {
        return this.directionType == null ? 500 : this.directionType.getHttpStatus();
    }

    private static /* synthetic */ void lambda$validateAttributes$6(JsonNode scimNode, SchemaAttribute metaAttribute, JsonNode childNode) {
        if (!childNode.isArray() || childNode.size() != 0) {
            JsonHelper.addAttribute((JsonNode)scimNode, (String)metaAttribute.getName(), (JsonNode)childNode);
        }
    }

    protected static enum DirectionType {
        REQUEST(400),
        RESPONSE(500);

        private int httpStatus;

        private DirectionType(int httpStatus) {
            this.httpStatus = httpStatus;
        }

        private int getHttpStatus() {
            return this.httpStatus;
        }
    }
}

