/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.filter.antlr;

import de.captaingoldfish.scim.sdk.server.filter.antlr.ScimFilterParser;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class FilterAttributeName {
    private String resourceUri;
    private String attributeName;
    private String fullName;
    private String parentAttributeName;
    private String complexSubAttributeName;

    public FilterAttributeName(ScimFilterParser.ValuePathContext valuePathContext, ScimFilterParser.AttributePathContext attributePathContext) {
        this(valuePathContext == null ? null : valuePathContext.attributePath().attribute.getText(), attributePathContext);
    }

    public FilterAttributeName(String parentName, ScimFilterParser.AttributePathContext attributePathContext) {
        this.parentAttributeName = parentName == null ? null : parentName + ".";
        this.attributeName = attributePathContext.attribute.getText();
        this.complexSubAttributeName = attributePathContext.subattribute == null ? null : attributePathContext.subattribute.getText();
        this.resourceUri = this.resolveResourceUri(attributePathContext).orElse(null);
        this.fullName = (this.resourceUri == null ? "" : StringUtils.stripToEmpty((String)this.resourceUri) + ":") + this.getShortName();
    }

    public FilterAttributeName(String attributeName) {
        Pattern pattern = Pattern.compile("(([\\w:.]+):)?(\\w+)(\\.)?(\\w+)?");
        Matcher matcher = pattern.matcher(attributeName);
        if (matcher.matches()) {
            this.resourceUri = matcher.group(2);
            this.attributeName = matcher.group(3);
            this.complexSubAttributeName = matcher.group(5);
        }
        this.fullName = attributeName;
    }

    private Optional<String> resolveResourceUri(ScimFilterParser.AttributePathContext attributePathContext) {
        if (attributePathContext.resourceUri == null) {
            return Optional.empty();
        }
        String resourceUri = StringUtils.stripToEmpty((String)attributePathContext.resourceUri.getText());
        return Optional.of(StringUtils.stripToNull((String)resourceUri.replaceFirst(":$", "")));
    }

    public String getShortName() {
        return StringUtils.stripToNull((String)(StringUtils.stripToEmpty((String)this.parentAttributeName) + StringUtils.stripToEmpty((String)this.attributeName) + StringUtils.stripToEmpty(this.complexSubAttributeName == null ? null : "." + this.complexSubAttributeName)));
    }

    public String toString() {
        return this.fullName;
    }

    public String getResourceUri() {
        return this.resourceUri;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getParentAttributeName() {
        return this.parentAttributeName;
    }

    public String getComplexSubAttributeName() {
        return this.complexSubAttributeName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FilterAttributeName)) {
            return false;
        }
        FilterAttributeName other = (FilterAttributeName)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$resourceUri = this.getResourceUri();
        String other$resourceUri = other.getResourceUri();
        if (this$resourceUri == null ? other$resourceUri != null : !this$resourceUri.equals(other$resourceUri)) {
            return false;
        }
        String this$attributeName = this.getAttributeName();
        String other$attributeName = other.getAttributeName();
        if (this$attributeName == null ? other$attributeName != null : !this$attributeName.equals(other$attributeName)) {
            return false;
        }
        String this$fullName = this.getFullName();
        String other$fullName = other.getFullName();
        if (this$fullName == null ? other$fullName != null : !this$fullName.equals(other$fullName)) {
            return false;
        }
        String this$parentAttributeName = this.getParentAttributeName();
        String other$parentAttributeName = other.getParentAttributeName();
        if (this$parentAttributeName == null ? other$parentAttributeName != null : !this$parentAttributeName.equals(other$parentAttributeName)) {
            return false;
        }
        String this$complexSubAttributeName = this.getComplexSubAttributeName();
        String other$complexSubAttributeName = other.getComplexSubAttributeName();
        return !(this$complexSubAttributeName == null ? other$complexSubAttributeName != null : !this$complexSubAttributeName.equals(other$complexSubAttributeName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FilterAttributeName;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $resourceUri = this.getResourceUri();
        result = result * 59 + ($resourceUri == null ? 43 : $resourceUri.hashCode());
        String $attributeName = this.getAttributeName();
        result = result * 59 + ($attributeName == null ? 43 : $attributeName.hashCode());
        String $fullName = this.getFullName();
        result = result * 59 + ($fullName == null ? 43 : $fullName.hashCode());
        String $parentAttributeName = this.getParentAttributeName();
        result = result * 59 + ($parentAttributeName == null ? 43 : $parentAttributeName.hashCode());
        String $complexSubAttributeName = this.getComplexSubAttributeName();
        result = result * 59 + ($complexSubAttributeName == null ? 43 : $complexSubAttributeName.hashCode());
        return result;
    }
}

