/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.endpoints.authorize;

import de.captaingoldfish.scim.sdk.common.exceptions.ForbiddenException;
import de.captaingoldfish.scim.sdk.server.endpoints.features.EndpointType;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceType;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Authorization {
    public static final Logger log = LoggerFactory.getLogger(Authorization.class);

    default public String getClientId() {
        return null;
    }

    public Set<String> getClientRoles();

    default public void isClientAuthorized(ResourceType resourceType, EndpointType endpointType) {
        Set<String> defaultRoles = resourceType.getFeatures().getAuthorization().getRoles();
        switch (endpointType) {
            case CREATE: {
                this.isAuthorized(resourceType, endpointType, resourceType.getFeatures().getAuthorization().getRolesCreate(), defaultRoles);
                break;
            }
            case UPDATE: {
                this.isAuthorized(resourceType, endpointType, resourceType.getFeatures().getAuthorization().getRolesUpdate(), defaultRoles);
                break;
            }
            case DELETE: {
                this.isAuthorized(resourceType, endpointType, resourceType.getFeatures().getAuthorization().getRolesDelete(), defaultRoles);
                break;
            }
            default: {
                this.isAuthorized(resourceType, endpointType, resourceType.getFeatures().getAuthorization().getRolesGet(), defaultRoles);
            }
        }
    }

    default public void isAuthorized(ResourceType resourceType, EndpointType endpointType, Set<String> roles, Set<String> defaultRoles) {
        HashSet<String> effectiveRoles = new HashSet<String>(Optional.ofNullable(roles).orElse(new HashSet()));
        if (effectiveRoles.isEmpty()) {
            effectiveRoles.addAll(defaultRoles);
        }
        if (effectiveRoles.isEmpty()) {
            return;
        }
        if (!Optional.ofNullable(this.getClientRoles()).map(clientRoles -> clientRoles.containsAll(effectiveRoles)).orElse(false).booleanValue()) {
            log.debug("the client '{}' tried to execute an action without proper authorization. Required authorization is '{}' but the client has '{}'", new Object[]{this.getClientId(), effectiveRoles, this.getClientRoles()});
            throw new ForbiddenException("you are not authorized to access the '" + (Object)((Object)endpointType) + "' endpoint on resource type '" + resourceType.getName() + "'");
        }
    }

    default public boolean authenticate(Map<String, String> httpHeaders, Map<String, String> queryParams) {
        return true;
    }

    default public String getRealm() {
        return "SCIM";
    }
}

