/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.schemas.custom;

import com.fasterxml.jackson.databind.node.ObjectNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import de.captaingoldfish.scim.sdk.server.schemas.custom.EndpointControlFeature;
import de.captaingoldfish.scim.sdk.server.schemas.custom.ResourceTypeAuthorization;
import java.util.Optional;

public class ResourceTypeFeatures
extends ScimObjectNode {
    public ResourceTypeFeatures(boolean autoFiltering, boolean autoSorting, boolean singletonEndpoint, EndpointControlFeature endpointControlFeature) {
        super(null);
        this.setAutoFiltering(autoFiltering);
        this.setAutoSorting(autoSorting);
        this.setSingletonEndpoint(singletonEndpoint);
        this.setEndpointControlFeature(endpointControlFeature);
    }

    public boolean isSingletonEndpoint() {
        return this.getBooleanAttribute("singletonEndpoint").orElse(false);
    }

    public void setSingletonEndpoint(Boolean singletonEndpoint) {
        this.setAttribute("singletonEndpoint", singletonEndpoint);
    }

    public boolean isAutoFiltering() {
        return this.getBooleanAttribute("autoFiltering").orElse(false);
    }

    public void setAutoFiltering(Boolean autoFiltering) {
        this.setAttribute("autoFiltering", autoFiltering);
    }

    public boolean isAutoSorting() {
        return this.getBooleanAttribute("autoSorting").orElse(false);
    }

    public void setAutoSorting(Boolean autoSorting) {
        this.setAttribute("autoSorting", autoSorting);
    }

    public boolean isResourceTypeDisabled() {
        return this.getBooleanAttribute("disabled").orElse(false) != false || this.getEndpointControlFeature().isResourceTypeDisabled();
    }

    public void setResourceTypeDisabled(Boolean disabled) {
        this.setAttribute("disabled", disabled);
    }

    public EndpointControlFeature getEndpointControlFeature() {
        Optional endpointControl = this.getObjectAttribute("endpointControl", EndpointControlFeature.class);
        if (endpointControl.isPresent()) {
            return (EndpointControlFeature)((Object)endpointControl.get());
        }
        EndpointControlFeature endpointControlFeature = EndpointControlFeature.builder().build();
        this.setEndpointControlFeature(endpointControlFeature);
        return endpointControlFeature;
    }

    public void setEndpointControlFeature(EndpointControlFeature endpointControlFeature) {
        this.setAttribute("endpointControl", (ObjectNode)endpointControlFeature);
    }

    public ResourceTypeAuthorization getAuthorization() {
        Optional authorization = this.getObjectAttribute("authorization", ResourceTypeAuthorization.class);
        if (authorization.isPresent()) {
            return (ResourceTypeAuthorization)((Object)authorization.get());
        }
        ResourceTypeAuthorization resourceTypeAuthorization = ResourceTypeAuthorization.builder().build();
        this.setAuthorization(resourceTypeAuthorization);
        return resourceTypeAuthorization;
    }

    public void setAuthorization(ResourceTypeAuthorization resourceTypeAuthorization) {
        this.setAttribute("authorization", (ObjectNode)resourceTypeAuthorization);
    }

    public static ResourceTypeFeaturesBuilder builder() {
        return new ResourceTypeFeaturesBuilder();
    }

    public ResourceTypeFeatures() {
    }

    public static class ResourceTypeFeaturesBuilder {
        private boolean autoFiltering;
        private boolean autoSorting;
        private boolean singletonEndpoint;
        private EndpointControlFeature endpointControlFeature;

        ResourceTypeFeaturesBuilder() {
        }

        public ResourceTypeFeaturesBuilder autoFiltering(boolean autoFiltering) {
            this.autoFiltering = autoFiltering;
            return this;
        }

        public ResourceTypeFeaturesBuilder autoSorting(boolean autoSorting) {
            this.autoSorting = autoSorting;
            return this;
        }

        public ResourceTypeFeaturesBuilder singletonEndpoint(boolean singletonEndpoint) {
            this.singletonEndpoint = singletonEndpoint;
            return this;
        }

        public ResourceTypeFeaturesBuilder endpointControlFeature(EndpointControlFeature endpointControlFeature) {
            this.endpointControlFeature = endpointControlFeature;
            return this;
        }

        public ResourceTypeFeatures build() {
            return new ResourceTypeFeatures(this.autoFiltering, this.autoSorting, this.singletonEndpoint, this.endpointControlFeature);
        }

        public String toString() {
            return "ResourceTypeFeatures.ResourceTypeFeaturesBuilder(autoFiltering=" + this.autoFiltering + ", autoSorting=" + this.autoSorting + ", singletonEndpoint=" + this.singletonEndpoint + ", endpointControlFeature=" + (Object)((Object)this.endpointControlFeature) + ")";
        }
    }
}

