/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.endpoints.authorize;

import de.captaingoldfish.scim.sdk.common.exceptions.ForbiddenException;
import de.captaingoldfish.scim.sdk.server.endpoints.features.EndpointType;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceType;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Authorization {
    public static final Logger log = LoggerFactory.getLogger(Authorization.class);

    public String getClientId();

    public Set<String> getClientRoles();

    default public void isClientAuthorized(ResourceType resourceType, EndpointType endpointType) {
        switch (endpointType) {
            case CREATE: {
                this.isAuthorized(resourceType, endpointType, resourceType.getFeatures().getAuthorization().getRolesCreate());
                break;
            }
            case UPDATE: {
                this.isAuthorized(resourceType, endpointType, resourceType.getFeatures().getAuthorization().getRolesUpdate());
                break;
            }
            case DELETE: {
                this.isAuthorized(resourceType, endpointType, resourceType.getFeatures().getAuthorization().getRolesDelete());
                break;
            }
            default: {
                this.isAuthorized(resourceType, endpointType, resourceType.getFeatures().getAuthorization().getRolesGet());
            }
        }
    }

    default public void isAuthorized(ResourceType resourceType, EndpointType endpointType, Set<String> roles) {
        if (roles == null || roles.isEmpty()) {
            return;
        }
        if (!this.getClientRoles().containsAll(roles)) {
            log.debug("the client '{}' tried to execute an action without proper authorization. Required authorization is '{}' but the client has '{}'", new Object[]{this.getClientId(), roles, this.getClientRoles()});
            throw new ForbiddenException("you are not authorized to access the '" + (Object)((Object)endpointType) + "' endpoint on resource type '" + resourceType.getName() + "'");
        }
    }
}

