/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.endpoints;

import de.captaingoldfish.scim.sdk.common.constants.enums.HttpMethod;
import de.captaingoldfish.scim.sdk.common.exceptions.InternalServerException;
import de.captaingoldfish.scim.sdk.common.exceptions.ScimException;
import de.captaingoldfish.scim.sdk.common.resources.ServiceProvider;
import de.captaingoldfish.scim.sdk.common.response.ErrorResponse;
import de.captaingoldfish.scim.sdk.common.response.ScimResponse;
import de.captaingoldfish.scim.sdk.server.endpoints.BulkEndpoint;
import de.captaingoldfish.scim.sdk.server.endpoints.EndpointDefinition;
import de.captaingoldfish.scim.sdk.server.endpoints.ResourceEndpointHandler;
import de.captaingoldfish.scim.sdk.server.endpoints.authorize.Authorization;
import de.captaingoldfish.scim.sdk.server.endpoints.features.EndpointFeatureHandler;
import de.captaingoldfish.scim.sdk.server.endpoints.features.EndpointType;
import de.captaingoldfish.scim.sdk.server.utils.UriInfos;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceEndpoint
extends ResourceEndpointHandler {
    private static final Logger log = LoggerFactory.getLogger(ResourceEndpoint.class);

    public ResourceEndpoint(ServiceProvider serviceProvider, EndpointDefinition ... endpointDefinitions) {
        super(serviceProvider, endpointDefinitions);
    }

    public ScimResponse handleRequest(String requestUrl, HttpMethod httpMethod, String requestBody, Map<String, String> httpHeaders) {
        return this.handleRequest(requestUrl, httpMethod, requestBody, httpHeaders, null);
    }

    public ScimResponse handleRequest(String requestUrl, HttpMethod httpMethod, String requestBody, Map<String, String> httpHeaders, Authorization authorization) {
        try {
            UriInfos uriInfos = UriInfos.getRequestUrlInfos(this.getResourceTypeFactory(), requestUrl, httpMethod, httpHeaders);
            if ("/Bulk".equals(uriInfos.getResourceEndpoint())) {
                BulkEndpoint bulkEndpoint = new BulkEndpoint(this, this.getServiceProvider(), this.getResourceTypeFactory());
                return bulkEndpoint.bulk(uriInfos.getBaseUri(), requestBody, authorization);
            }
            return this.resolveRequest(httpMethod, requestBody, uriInfos, authorization);
        }
        catch (ScimException ex) {
            return new ErrorResponse(ex);
        }
        catch (Exception ex) {
            return new ErrorResponse((ScimException)new InternalServerException(ex.getMessage(), (Throwable)ex, null));
        }
    }

    protected ScimResponse resolveRequest(HttpMethod httpMethod, String requestBody, UriInfos uriInfos, Authorization authorization) {
        switch (httpMethod) {
            case POST: {
                if (uriInfos.isSearchRequest()) {
                    EndpointFeatureHandler.handleEndpointFeatures(uriInfos.getResourceType(), EndpointType.LIST, authorization);
                    return this.listResources(uriInfos.getResourceEndpoint(), requestBody, uriInfos::getBaseUri, authorization);
                }
                EndpointFeatureHandler.handleEndpointFeatures(uriInfos.getResourceType(), EndpointType.CREATE, authorization);
                return this.createResource(uriInfos.getResourceEndpoint(), requestBody, uriInfos::getBaseUri, authorization);
            }
            case GET: {
                if (uriInfos.isSearchRequest() && !uriInfos.getResourceType().getFeatures().isSingletonEndpoint()) {
                    EndpointFeatureHandler.handleEndpointFeatures(uriInfos.getResourceType(), EndpointType.LIST, authorization);
                    String startIndex = uriInfos.getQueryParameters().get("startIndex".toLowerCase());
                    String count = uriInfos.getQueryParameters().get("count");
                    return this.listResources(uriInfos.getResourceEndpoint(), startIndex == null ? null : Long.valueOf(Long.parseLong(startIndex)), count == null ? null : Integer.valueOf(Integer.parseInt(count)), uriInfos.getQueryParameters().get("filter"), uriInfos.getQueryParameters().get("sortBy".toLowerCase()), uriInfos.getQueryParameters().get("sortOrder".toLowerCase()), uriInfos.getQueryParameters().get("attributes"), uriInfos.getQueryParameters().get("excludedAttributes".toLowerCase()), uriInfos::getBaseUri, authorization);
                }
                EndpointFeatureHandler.handleEndpointFeatures(uriInfos.getResourceType(), EndpointType.GET, authorization);
                return this.getResource(uriInfos.getResourceEndpoint(), uriInfos.getResourceId(), uriInfos.getQueryParameters().get("attributes"), uriInfos.getQueryParameters().get("excludedAttributes".toLowerCase()), uriInfos.getHttpHeaders(), uriInfos::getBaseUri, authorization);
            }
            case PUT: {
                EndpointFeatureHandler.handleEndpointFeatures(uriInfos.getResourceType(), EndpointType.UPDATE, authorization);
                return this.updateResource(uriInfos.getResourceEndpoint(), uriInfos.getResourceId(), requestBody, uriInfos.getHttpHeaders(), uriInfos::getBaseUri, authorization);
            }
            case PATCH: {
                EndpointFeatureHandler.handleEndpointFeatures(uriInfos.getResourceType(), EndpointType.UPDATE, authorization);
                return this.patchResource(uriInfos.getResourceEndpoint(), uriInfos.getResourceId(), requestBody, uriInfos.getQueryParameters().get("attributes"), uriInfos.getQueryParameters().get("excludedAttributes".toLowerCase()), uriInfos.getHttpHeaders(), uriInfos::getBaseUri, authorization);
            }
        }
        EndpointFeatureHandler.handleEndpointFeatures(uriInfos.getResourceType(), EndpointType.DELETE, authorization);
        return this.deleteResource(uriInfos.getResourceEndpoint(), uriInfos.getResourceId(), uriInfos.getHttpHeaders(), authorization);
    }
}

