/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.schemas.validation;

import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.common.constants.enums.ReferenceTypes;
import de.captaingoldfish.scim.sdk.common.constants.enums.Type;
import de.captaingoldfish.scim.sdk.common.exceptions.InvalidDateTimeRepresentationException;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimBinaryNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimBooleanNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimDoubleNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimIntNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimLongNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimTextNode;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.common.utils.TimeUtils;
import de.captaingoldfish.scim.sdk.server.schemas.exceptions.AttributeValidationException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Base64;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SimpleAttributeValidator {
    private static final Logger log = LoggerFactory.getLogger(SimpleAttributeValidator.class);

    public static boolean isSimpleNode(JsonNode attribute) {
        return attribute.isNull() || !attribute.isArray() && !attribute.isObject();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JsonNode parseNodeTypeAndValidate(SchemaAttribute schemaAttribute, JsonNode jsonNode) {
        Supplier<JsonNode> validatedNodeSupplier;
        JsonNode attribute;
        block18: {
            log.trace("Validating simple attribute '{}'", (Object)schemaAttribute.getScimNodeName());
            if (!SimpleAttributeValidator.isSimpleNode(jsonNode)) {
                if (jsonNode.isArray() && jsonNode.size() == 1 && SimpleAttributeValidator.isSimpleNode(jsonNode.get(0))) {
                    attribute = jsonNode.get(0);
                    break block18;
                } else {
                    String errorMessage = String.format("Attribute '%s' is expected to be a simple attribute of type '%s' but is '%s'", schemaAttribute.getFullResourceName(), schemaAttribute.getType(), jsonNode);
                    throw new AttributeValidationException(schemaAttribute, errorMessage);
                }
            }
            attribute = jsonNode;
        }
        SimpleAttributeValidator.checkCanonicalValues(schemaAttribute, attribute);
        boolean isNodeTypeValid = false;
        Type type = schemaAttribute.getType();
        switch (type) {
            case STRING: {
                isNodeTypeValid = attribute.isTextual() || attribute.isObject();
                String value = attribute.isTextual() ? attribute.textValue() : attribute.toString();
                validatedNodeSupplier = () -> new ScimTextNode(schemaAttribute, value);
                break;
            }
            case BINARY: {
                isNodeTypeValid = SimpleAttributeValidator.isNodeTypeBinary(schemaAttribute, attribute);
                if (attribute.isBinary()) {
                    validatedNodeSupplier = () -> new ScimBinaryNode(schemaAttribute, SimpleAttributeValidator.getBinaryValueOfJsonNode(attribute));
                    break;
                }
                validatedNodeSupplier = () -> new ScimTextNode(schemaAttribute, attribute.textValue());
                break;
            }
            case BOOLEAN: {
                isNodeTypeValid = attribute.isBoolean();
                validatedNodeSupplier = () -> new ScimBooleanNode(schemaAttribute, attribute.booleanValue());
                break;
            }
            case INTEGER: {
                boolean bl = isNodeTypeValid = attribute.isInt() || attribute.isLong() || attribute.isBigDecimal();
                if ((long)attribute.intValue() == attribute.longValue()) {
                    validatedNodeSupplier = () -> new ScimIntNode(schemaAttribute, attribute.intValue());
                    break;
                }
                validatedNodeSupplier = () -> new ScimLongNode(schemaAttribute, attribute.longValue());
                break;
            }
            case DECIMAL: {
                isNodeTypeValid = attribute.isInt() || attribute.isLong() || attribute.isFloat() || attribute.isDouble() || attribute.isBigDecimal();
                validatedNodeSupplier = () -> new ScimDoubleNode(schemaAttribute, attribute.doubleValue());
                break;
            }
            case DATE_TIME: {
                isNodeTypeValid = attribute.isTextual();
                if (isNodeTypeValid) {
                    SimpleAttributeValidator.parseDateTime(schemaAttribute, attribute.textValue());
                }
                validatedNodeSupplier = () -> new ScimTextNode(schemaAttribute, attribute.textValue());
                break;
            }
            default: {
                isNodeTypeValid = attribute.isTextual();
                if (isNodeTypeValid) {
                    SimpleAttributeValidator.validateValueNodeWithReferenceTypes(schemaAttribute, attribute);
                }
                validatedNodeSupplier = () -> new ScimTextNode(schemaAttribute, attribute.textValue());
            }
        }
        if (isNodeTypeValid) return validatedNodeSupplier.get();
        Optional<JsonNode> fallbackNode = SimpleAttributeValidator.tryToParseFromStringValue(schemaAttribute, attribute);
        if (fallbackNode.isPresent()) {
            validatedNodeSupplier = fallbackNode::get;
            return validatedNodeSupplier.get();
        }
        String errorMessage = String.format("Value of attribute '%s' is not of type '%s' but of type '%s' with value '%s'", schemaAttribute.getFullResourceName(), type.getValue(), StringUtils.lowerCase((String)attribute.getNodeType().toString()), attribute);
        throw new AttributeValidationException(schemaAttribute, errorMessage);
    }

    private static Optional<JsonNode> tryToParseFromStringValue(SchemaAttribute schemaAttribute, JsonNode valueNode) {
        try {
            switch (schemaAttribute.getType()) {
                case BOOLEAN: {
                    boolean isBoolString = Arrays.asList("true", "false").contains(valueNode.textValue());
                    if (isBoolString) {
                        return Optional.of(new ScimBooleanNode(schemaAttribute, Boolean.parseBoolean(valueNode.textValue())));
                    }
                    return Optional.empty();
                }
                case INTEGER: {
                    long longValue = Long.parseLong(valueNode.textValue());
                    if (longValue == (long)((int)longValue)) {
                        return Optional.of(new ScimIntNode(schemaAttribute, (int)longValue));
                    }
                    return Optional.of(new ScimLongNode(schemaAttribute, longValue));
                }
                case DECIMAL: {
                    return Optional.of(new ScimDoubleNode(schemaAttribute, new BigDecimal(valueNode.textValue()).doubleValue()));
                }
            }
        }
        catch (Exception ex) {
            log.trace(ex.getMessage(), (Throwable)ex);
        }
        return Optional.empty();
    }

    private static boolean isNodeTypeBinary(SchemaAttribute schemaAttribute, JsonNode attribute) {
        if (attribute.isBinary()) {
            return true;
        }
        if (attribute.isTextual()) {
            try {
                Base64.getDecoder().decode(attribute.textValue());
                return true;
            }
            catch (IllegalArgumentException ex) {
                log.trace(ex.getMessage(), (Throwable)ex);
                log.debug(String.format("Data of attribute '%s' is not valid Base64 encoded data", schemaAttribute.getFullResourceName()));
                return false;
            }
        }
        return false;
    }

    private static void parseDateTime(SchemaAttribute schemaAttribute, String textValue) {
        try {
            TimeUtils.parseDateTime((String)textValue);
        }
        catch (InvalidDateTimeRepresentationException ex) {
            throw new AttributeValidationException(schemaAttribute, String.format("Given value is not a valid dateTime '%s'", textValue));
        }
    }

    private static void validateValueNodeWithReferenceTypes(SchemaAttribute schemaAttribute, JsonNode valueNode) {
        boolean isValidReferenceType = false;
        for (ReferenceTypes referenceType : schemaAttribute.getReferenceTypes()) {
            switch (referenceType) {
                case RESOURCE: 
                case URI: {
                    isValidReferenceType = SimpleAttributeValidator.parseUri(valueNode.textValue());
                    break;
                }
                case URL: {
                    isValidReferenceType = SimpleAttributeValidator.parseUrl(valueNode.textValue());
                    break;
                }
                default: {
                    isValidReferenceType = true;
                }
            }
            if (!isValidReferenceType) continue;
            break;
        }
        if (!isValidReferenceType) {
            String errorMessage = String.format("Attribute '%s' is a referenceType and must apply to one of the following types '%s' but value is '%s'", schemaAttribute.getFullResourceName(), schemaAttribute.getReferenceTypes(), valueNode.textValue());
            throw new AttributeValidationException(schemaAttribute, errorMessage);
        }
    }

    private static boolean parseUrl(String textValue) {
        try {
            new URL(textValue);
            return true;
        }
        catch (MalformedURLException ex) {
            log.debug(ex.getMessage());
            return false;
        }
    }

    private static boolean parseUri(String textValue) {
        try {
            new URI(textValue);
            return true;
        }
        catch (URISyntaxException ex) {
            log.debug(ex.getMessage());
            return false;
        }
    }

    protected static void checkCanonicalValues(SchemaAttribute schemaAttribute, JsonNode valueNode) {
        if (schemaAttribute.getCanonicalValues().isEmpty()) {
            return;
        }
        String value = valueNode.textValue();
        AtomicBoolean caseInsensitiveMatch = new AtomicBoolean(false);
        Predicate<String> compare = s -> {
            if (schemaAttribute.isCaseExact()) {
                caseInsensitiveMatch.compareAndSet(false, StringUtils.equalsIgnoreCase((CharSequence)s, (CharSequence)value));
                return StringUtils.equals((CharSequence)s, (CharSequence)value);
            }
            return StringUtils.equalsIgnoreCase((CharSequence)s, (CharSequence)value);
        };
        if (schemaAttribute.getCanonicalValues().stream().noneMatch(compare)) {
            String errorMessage = schemaAttribute.isCaseExact() && caseInsensitiveMatch.get() ? String.format("Attribute '%s' is caseExact and does not match its canonicalValues '%s' actual value is '%s'", schemaAttribute.getFullResourceName(), schemaAttribute.getCanonicalValues(), value) : String.format("Attribute '%s' does not match one of its canonicalValues '%s' actual value is '%s'", schemaAttribute.getFullResourceName(), schemaAttribute.getCanonicalValues(), value);
            throw new AttributeValidationException(schemaAttribute, errorMessage);
        }
    }

    private static byte[] getBinaryValueOfJsonNode(JsonNode attribute) {
        return attribute.binaryValue();
    }

    private SimpleAttributeValidator() {
    }
}

