/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.schemas.validation;

import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.common.constants.enums.HttpMethod;
import de.captaingoldfish.scim.sdk.common.resources.ServiceProvider;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.server.endpoints.validation.ValidationContext;
import de.captaingoldfish.scim.sdk.server.schemas.exceptions.AttributeValidationException;
import de.captaingoldfish.scim.sdk.server.schemas.validation.AbstractSchemaValidator;
import de.captaingoldfish.scim.sdk.server.schemas.validation.RequestAttributeValidator;
import java.util.Optional;

public class RequestSchemaValidator
extends AbstractSchemaValidator {
    private final HttpMethod httpMethod;
    private final ValidationContext validationContext;

    public RequestSchemaValidator(ServiceProvider serviceProvider, Class resourceNodeType, HttpMethod httpMethod) {
        this(serviceProvider, resourceNodeType, httpMethod, null);
    }

    public RequestSchemaValidator(ServiceProvider serviceProvider, Class resourceNodeType, HttpMethod httpMethod, ValidationContext validationContext) {
        super(serviceProvider, resourceNodeType);
        this.httpMethod = httpMethod;
        this.validationContext = validationContext;
    }

    @Override
    protected Optional<JsonNode> validateAttribute(SchemaAttribute schemaAttribute, JsonNode attribute) {
        try {
            return RequestAttributeValidator.validateAttribute(this.getServiceProvider(), schemaAttribute, attribute, this.httpMethod);
        }
        catch (AttributeValidationException ex) {
            if (this.validationContext == null) {
                throw ex;
            }
            this.validationContext.addExceptionMessages(ex);
            return Optional.empty();
        }
    }

    @Override
    protected int getHttpStatusCode() {
        return 400;
    }

    protected ValidationContext getValidationContext() {
        return this.validationContext;
    }
}

