/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.schemas.validation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.common.utils.JsonHelper;
import de.captaingoldfish.scim.sdk.server.schemas.exceptions.AttributeValidationException;
import de.captaingoldfish.scim.sdk.server.schemas.validation.ContextValidator;
import de.captaingoldfish.scim.sdk.server.schemas.validation.ValidationSelector;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComplexAttributeValidator {
    private static final Logger log = LoggerFactory.getLogger(ComplexAttributeValidator.class);

    static JsonNode parseNodeTypeAndValidate(SchemaAttribute schemaAttribute, JsonNode attribute, ContextValidator contextValidator) {
        JsonNode effectiveAttribute;
        block5: {
            block6: {
                block7: {
                    log.trace("Validating complex attribute '{}'", (Object)schemaAttribute.getScimNodeName());
                    effectiveAttribute = attribute;
                    if (effectiveAttribute.isObject()) break block5;
                    if (!effectiveAttribute.isArray() || effectiveAttribute.size() != 1) break block6;
                    if (!effectiveAttribute.get(0).isObject()) break block7;
                    effectiveAttribute = effectiveAttribute.get(0);
                    break block5;
                }
                if (effectiveAttribute.get(0) instanceof TextNode && (effectiveAttribute = JsonHelper.readJsonDocument((String)effectiveAttribute.get(0).textValue())).isObject()) break block5;
            }
            String errorMessage = String.format("Attribute '%s' must be of type object but is '%s'", schemaAttribute.getFullResourceName(), effectiveAttribute);
            throw new AttributeValidationException(schemaAttribute, errorMessage);
        }
        ScimObjectNode scimObjectNode = new ScimObjectNode(schemaAttribute);
        for (SchemaAttribute subAttribute : schemaAttribute.getSubAttributes()) {
            JsonNode subNode;
            Optional<JsonNode> validatedNode = ValidationSelector.validateNode(subAttribute, subNode = effectiveAttribute.get(subAttribute.getName()), contextValidator);
            if (!validatedNode.isPresent()) continue;
            scimObjectNode.set(subAttribute.getName(), validatedNode.get());
        }
        if (scimObjectNode.isEmpty()) {
            log.trace("Evaluated complex node '{}' to an empty object.", (Object)schemaAttribute.getFullResourceName());
        }
        return scimObjectNode.isEmpty() ? null : scimObjectNode;
    }
}

